/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.alloc.factory;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import reactor.fn.Supplier;

public class BatchFactorySupplier<T>
implements Supplier<T> {
    private static final AtomicIntegerFieldUpdater<BatchFactorySupplier> NEXT_UPD = AtomicIntegerFieldUpdater.newUpdater(BatchFactorySupplier.class, "next");
    private final ReentrantLock fillLock = new ReentrantLock(true);
    private final int size;
    private final Supplier<T> factory;
    private final T[] objs;
    private volatile int next = 0;

    public BatchFactorySupplier(int size, Supplier<T> factory) {
        this.size = size;
        this.factory = factory;
        this.objs = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.objs[i] = factory.get();
        }
    }

    public int size() {
        return this.size;
    }

    public int remaining() {
        return this.size - this.next;
    }

    @Override
    public T get() {
        int next = NEXT_UPD.getAndIncrement(this);
        if (next >= this.size) {
            this.fill();
            return this.get();
        }
        T obj = this.objs[next];
        this.objs[next] = null;
        return obj;
    }

    protected void fill() {
        this.fillLock.lock();
        try {
            if (this.next >= this.size) {
                for (int i = 0; i < this.size; ++i) {
                    this.objs[i] = this.factory.get();
                }
                NEXT_UPD.set(this, 0);
            }
        }
        finally {
            this.fillLock.unlock();
        }
    }
}

