/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import reactor.core.alloc.factory.BatchFactorySupplier;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.InsufficientCapacityException;
import reactor.fn.Supplier;

public abstract class MultiThreadDispatcher
extends AbstractLifecycleDispatcher {
    private final int backlog;
    private final int numberThreads;
    private final BatchFactorySupplier<MultiThreadTask> taskFactory;

    protected MultiThreadDispatcher(int numberThreads, int backlog) {
        this.backlog = backlog;
        this.numberThreads = numberThreads;
        this.taskFactory = new BatchFactorySupplier<MultiThreadTask>(backlog, new Supplier<MultiThreadTask>(){

            @Override
            public MultiThreadTask get() {
                return new MultiThreadTask();
            }
        });
    }

    @Override
    public boolean supportsOrdering() {
        return false;
    }

    @Override
    public long backlogSize() {
        return this.backlog;
    }

    public int poolSize() {
        return this.numberThreads;
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateRecursiveTask() {
        throw new IllegalStateException("MultiThreadDispatchers cannot allocate recursively");
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateTask() {
        return this.taskFactory.get();
    }

    @Override
    protected AbstractLifecycleDispatcher.Task tryAllocateTask() throws InsufficientCapacityException {
        if (this.taskFactory.remaining() == 0) {
            throw InsufficientCapacityException.INSTANCE;
        }
        return this.allocateTask();
    }

    @Override
    public boolean inContext() {
        return false;
    }

    protected class MultiThreadTask
    extends AbstractLifecycleDispatcher.Task {
        protected MultiThreadTask() {
            super(MultiThreadDispatcher.this);
        }

        @Override
        public void run() {
            AbstractLifecycleDispatcher.route(this);
        }
    }
}

