/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch.forkjoin;

import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.impl.list.mutable.FastList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.forkjoin.ForkJoinTask;
import reactor.fn.Function;
import reactor.rx.broadcast.Broadcaster;

public class ForkJoinPool {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Environment env;
    private final Dispatcher dispatcher;
    private final Executor executor;

    public ForkJoinPool(Environment env) {
        this(env, env.getDefaultDispatcher(), env.getDispatcher("threadPoolExecutor"));
    }

    public ForkJoinPool(Environment env, Dispatcher dispatcher, Executor executor) {
        this.env = env;
        this.dispatcher = dispatcher;
        this.executor = executor;
    }

    public <V> ForkJoinTask<ImmutableList<V>, Broadcaster<ImmutableList<V>>> join(Function<?, V> ... tasks) {
        return this.join(Arrays.asList(tasks));
    }

    public <V> ForkJoinTask<ImmutableList<V>, Broadcaster<ImmutableList<V>>> join(Collection<Function<?, V>> tasks) {
        final Broadcaster d = Broadcaster.create(this.env, this.dispatcher);
        ForkJoinTask<ImmutableList<V>, Broadcaster<ImmutableList<V>>> t = new ForkJoinTask<ImmutableList<V>, Broadcaster<ImmutableList<V>>>(this.executor, d);
        final AtomicInteger count = new AtomicInteger(tasks.size());
        final FastList results = FastList.newList();
        for (final Function<?, V> fn : tasks) {
            t.add(new Function<Object, ImmutableList<V>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ImmutableList<V> apply(Object o) {
                    try {
                        Object result = fn.apply(o);
                        FastList fastList = results;
                        synchronized (fastList) {
                            results.add(result);
                        }
                    }
                    finally {
                        if (count.decrementAndGet() == 0) {
                            d.onNext(results.toImmutable());
                            d.onComplete();
                        }
                    }
                    return null;
                }
            });
        }
        return t;
    }

    public <V> ForkJoinTask<V, Broadcaster<V>> fork() {
        Broadcaster d = Broadcaster.create(this.env, this.dispatcher);
        return new ForkJoinTask(this.executor, d);
    }
}

