/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch.forkjoin;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure;
import com.gs.collections.impl.list.mutable.MultiReaderFastList;
import java.util.concurrent.Executor;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.rx.action.Action;

public class ForkJoinTask<T, C extends Action<T, T>>
implements Consumer<Object> {
    private final MultiReaderFastList<Function<?, ?>> tasks = MultiReaderFastList.newList();
    private final Executor executor;
    private final C deferred;

    ForkJoinTask(Executor executor, C deferred) {
        this.executor = executor;
        this.deferred = deferred;
    }

    public MutableList<Function<?, ?>> getTasks() {
        return this.tasks;
    }

    public <V> ForkJoinTask<T, C> add(Function<V, T> fn) {
        this.tasks.add(fn);
        return this;
    }

    public C compose() {
        return this.deferred;
    }

    public void submit() {
        this.accept((Object)null);
    }

    public <V> void submit(V arg) {
        this.accept(arg);
    }

    @Override
    public void accept(final Object arg) {
        this.tasks.forEach((Procedure)new CheckedProcedure<Function>(){

            public void safeValue(final Function fn) throws Exception {
                ForkJoinTask.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object result = fn.apply(arg);
                            if (null != result) {
                                ForkJoinTask.this.deferred.onNext(result);
                            }
                        }
                        catch (Exception e) {
                            ForkJoinTask.this.deferred.onError(e);
                        }
                    }
                });
            }
        });
    }
}

