/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch.processor.spec;

import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.selector.Selectors;
import reactor.core.dispatch.processor.Processor;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Supplier;
import reactor.jarjar.com.lmax.disruptor.BlockingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.BusySpinWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.SleepingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.YieldingWaitStrategy;

public class ProcessorSpec<T>
implements Supplier<Processor<T>> {
    private Registry<Consumer<Throwable>> errorConsumers = Registries.create();
    private boolean multiThreadedProducer = false;
    private int dataBufferSize = -1;
    private WaitStrategy waitStrategy = null;
    private Supplier<T> dataSupplier;
    private Consumer<T> consumer;

    public ProcessorSpec<T> multiThreadedProducer() {
        this.multiThreadedProducer = true;
        return this;
    }

    public ProcessorSpec<T> singleThreadedProducer() {
        this.multiThreadedProducer = false;
        return this;
    }

    public ProcessorSpec<T> dataBufferSize(int dataBufferSize) {
        this.dataBufferSize = dataBufferSize;
        return this;
    }

    public ProcessorSpec<T> dataSupplier(Supplier<T> dataSupplier) {
        Assert.isNull(this.dataSupplier, "Data Supplier is already set.");
        this.dataSupplier = dataSupplier;
        return this;
    }

    public ProcessorSpec<T> waitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        return this;
    }

    public ProcessorSpec<T> blockingWaitStrategy() {
        this.waitStrategy = new BlockingWaitStrategy();
        return this;
    }

    public ProcessorSpec<T> sleepingWaitStrategy() {
        this.waitStrategy = new SleepingWaitStrategy();
        return this;
    }

    public ProcessorSpec<T> yieldingWaitStrategy() {
        this.waitStrategy = new YieldingWaitStrategy();
        return this;
    }

    public ProcessorSpec<T> busySpinWaitStrategy() {
        this.waitStrategy = new BusySpinWaitStrategy();
        return this;
    }

    public ProcessorSpec<T> consume(Consumer<T> consumer) {
        this.consumer = consumer;
        return this;
    }

    public ProcessorSpec<T> when(Class<? extends Throwable> type, Consumer<Throwable> errorConsumer) {
        this.errorConsumers.register(Selectors.type(type), errorConsumer);
        return this;
    }

    @Override
    public Processor<T> get() {
        return new Processor<T>(this.dataSupplier, this.consumer, this.errorConsumers, this.waitStrategy, this.multiThreadedProducer, this.dataBufferSize);
    }
}

