/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.support;

import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import reactor.fn.Supplier;

@ThreadSafe
public class PartitionedReferencePile<T>
implements Supplier<T>,
Iterable<T> {
    private final int size;
    private final Function0<FastList<T>> preAllocatedListFn = new Function0<FastList<T>>(){

        public FastList<T> value() {
            FastList vals = FastList.newList((int)PartitionedReferencePile.this.size);
            for (int i = 0; i < PartitionedReferencePile.this.size; ++i) {
                vals.add(PartitionedReferencePile.this.factory.get());
            }
            return vals;
        }
    };
    private final Supplier<T> factory;
    private final MutableMap<Long, FastList<T>> partitions = UnifiedMap.newMap();
    private final MutableMap<Long, AtomicInteger> nextAvailable = UnifiedMap.newMap();
    private final Function0<AtomicInteger> atomicIntegerFn = new Function0<AtomicInteger>(){

        public AtomicInteger value() {
            return new AtomicInteger(-1);
        }
    };
    private final Procedure2<FastList<T>, FastList<T>> zipFn = new Procedure2<FastList<T>, FastList<T>>(){

        public void value(FastList<T> vals, FastList<T> agg) {
            agg.addAll(vals);
        }
    };

    public PartitionedReferencePile(Supplier<T> factory) {
        this(1024, factory);
    }

    public PartitionedReferencePile(int size, Supplier<T> factory) {
        this.size = size;
        this.factory = factory;
    }

    @Override
    public T get() {
        Long threadId = Thread.currentThread().getId();
        int nextAvail = ((AtomicInteger)this.nextAvailable.getIfAbsentPut((Object)threadId, this.atomicIntegerFn)).incrementAndGet();
        FastList vals = (FastList)this.partitions.getIfAbsentPut((Object)threadId, this.preAllocatedListFn);
        int len = vals.size();
        if (len == nextAvail) {
            vals.addAll((Collection)this.preAllocatedListFn.value());
        }
        return (T)vals.get(nextAvail);
    }

    public ImmutableSet<T> collect() {
        final UnifiedSet vals = UnifiedSet.newSet();
        this.partitions.keysView().forEach((Procedure)new Procedure<Long>(){

            public void value(Long threadId) {
                Iterator iter = PartitionedReferencePile.this.iteratorFor(threadId);
                while (iter.hasNext()) {
                    vals.add(iter.next());
                }
            }
        });
        return vals.toImmutable();
    }

    public boolean isEmpty() {
        Long threadId = Thread.currentThread().getId();
        FastList vals = (FastList)this.partitions.getIfAbsentPut((Object)threadId, this.preAllocatedListFn);
        return !vals.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iteratorFor(Thread.currentThread().getId());
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder("PartitionedReferencePile{\n");
        this.partitions.forEachKeyValue(new Procedure2<Long, FastList<T>>(){

            public void value(Long threadId, FastList<T> vals) {
                sb.append("\tthread:").append(threadId).append("=").append(vals.getFirst().getClass().getSimpleName()).append("[").append(vals.size()).append("],\n");
            }
        });
        sb.append("}");
        return sb.toString();
    }

    private Iterator<T> iteratorFor(Long threadId) {
        AtomicInteger nextAvail = (AtomicInteger)this.nextAvailable.getIfAbsentPut((Object)threadId, this.atomicIntegerFn);
        final FastList vals = (FastList)this.partitions.getIfAbsentPut((Object)threadId, this.preAllocatedListFn);
        final int end = nextAvail.getAndSet(-1);
        return new Iterator<T>(){
            int currIdx = 0;

            @Override
            public boolean hasNext() {
                return this.currIdx <= end;
            }

            @Override
            public T next() {
                int idx = this.currIdx++;
                return vals.get(idx);
            }

            @Override
            public void remove() {
                throw new IllegalStateException("PartitionedReferencePile Iterators are read-only");
            }
        };
    }
}

