/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn.support;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import reactor.core.support.Assert;
import reactor.fn.Consumer;

public class Resequencer<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong slots = new AtomicLong();
    private final AtomicLong claims = new AtomicLong();
    private final Map<Long, T> results = new TreeMap<Long, T>();
    private final Consumer<T> delegate;
    private final long maxBacklog;

    public Resequencer(@Nonnull Consumer<T> delegate) {
        this(delegate, Integer.MAX_VALUE);
    }

    public Resequencer(@Nonnull Consumer<T> delegate, long maxBacklog) {
        this.delegate = delegate;
        this.maxBacklog = maxBacklog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(long slot, T t) {
        this.lock.lock();
        try {
            Assert.notNull(slot, "Slot cannot be null.");
            Assert.isTrue(slot <= this.slots.get(), "Cannot accept a value for slot " + slot + " when only " + this.slots.get() + " slots have been " + "allocated.");
            long next = this.claims.get() + 1L;
            if (slot == next) {
                this.delegate.accept(t);
                this.claims.incrementAndGet();
                if (!this.results.isEmpty()) {
                    for (Map.Entry<Long, T> entry : this.results.entrySet()) {
                        this.delegate.accept(entry.getValue());
                        this.claims.incrementAndGet();
                    }
                    this.results.clear();
                }
            } else {
                Assert.isTrue(slot - this.claims.get() < this.maxBacklog, "Cannot backlog more than " + this.maxBacklog + " items.");
                this.results.put(slot, t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long next() {
        return this.slots.incrementAndGet();
    }
}

