/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn.support;

import java.util.concurrent.atomic.AtomicBoolean;
import reactor.fn.Consumer;
import reactor.fn.support.CancelConsumerException;

public class SingleUseConsumer<T>
implements Consumer<T> {
    private final AtomicBoolean called = new AtomicBoolean();
    private final Consumer<? super T> delegate;

    public SingleUseConsumer() {
        this.delegate = null;
    }

    public SingleUseConsumer(Consumer<? super T> delegate) {
        this.delegate = delegate;
    }

    public static <T> Consumer<T> once(Consumer<? super T> delegate) {
        return new SingleUseConsumer<T>(delegate);
    }

    @Override
    public final void accept(T t) {
        if (this.called.get()) {
            return;
        }
        if (this.called.compareAndSet(false, true)) {
            if (null != this.delegate) {
                this.delegate.accept(t);
            } else {
                this.doAccept(t);
            }
            throw new CancelConsumerException();
        }
    }

    protected void doAccept(T t) {
    }
}

