/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn.timer;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.bus.registry.Registration;
import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.Selector;
import reactor.core.support.Assert;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.fn.Consumer;
import reactor.fn.support.CancelConsumerException;
import reactor.fn.timer.Timer;

public class SimpleHashWheelTimer
implements Timer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHashWheelTimer.class);
    private final Registry<Consumer<Long>> tasks = Registries.create(true, false, null);
    private final int resolution;
    private final Thread loop;

    public SimpleHashWheelTimer() {
        this(50);
    }

    public SimpleHashWheelTimer(final int resolution) {
        this.resolution = resolution;
        this.loop = new NamedDaemonThreadFactory("simple-hash-wheel-timer").newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    long now = SimpleHashWheelTimer.now(resolution);
                    for (Registration reg : SimpleHashWheelTimer.this.tasks.select(now)) {
                        try {
                            if (reg.isCancelled() || reg.isPaused()) continue;
                            ((Consumer)reg.getObject()).accept(now);
                        }
                        catch (CancelConsumerException cce) {
                            reg.cancel();
                        }
                        catch (Throwable t) {
                            LOG.error(t.getMessage(), t);
                        }
                        finally {
                            if (!reg.isCancelAfterUse()) continue;
                            reg.cancel();
                        }
                    }
                    try {
                        Thread.sleep(resolution);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        });
        this.loop.start();
    }

    @Override
    public long getResolution() {
        return this.resolution;
    }

    @Override
    public Registration<? extends Consumer<Long>> schedule(Consumer<Long> consumer, long period, TimeUnit timeUnit, long delayInMilliseconds) {
        Assert.isTrue(!this.loop.isInterrupted(), "Cannot submit tasks to this timer as it has been cancelled.");
        long milliPeriod = TimeUnit.MILLISECONDS.convert(period, timeUnit);
        Assert.isTrue(milliPeriod % (long)this.resolution == 0L, "Period must be a multiple of timer resolution (e.g. period % resolution == 0 )");
        return this.tasks.register(new PeriodSelector(milliPeriod, delayInMilliseconds, this.resolution), consumer);
    }

    @Override
    public Registration<? extends Consumer<Long>> schedule(Consumer<Long> consumer, long period, TimeUnit timeUnit) {
        return this.schedule(consumer, period, timeUnit, 0L);
    }

    @Override
    public Registration<? extends Consumer<Long>> submit(Consumer<Long> consumer, long delay, TimeUnit timeUnit) {
        Assert.isTrue(!this.loop.isInterrupted(), "Cannot submit tasks to this timer as it has been cancelled.");
        long ms = TimeUnit.MILLISECONDS.convert(delay, timeUnit);
        return this.tasks.register(new PeriodSelector(ms, ms, this.resolution), consumer).cancelAfterUse();
    }

    @Override
    public Registration<? extends Consumer<Long>> submit(Consumer<Long> consumer) {
        return this.submit(consumer, this.resolution, TimeUnit.MILLISECONDS);
    }

    @Override
    public void cancel() {
        this.loop.interrupt();
    }

    private static long now(int resolution) {
        return (long)(Math.ceil(System.currentTimeMillis() / (long)resolution) * (double)resolution);
    }

    private static class PeriodSelector
    implements Selector<Long> {
        private final long period;
        private final long delay;
        private final long createdMillis;
        private final int resolution;

        private PeriodSelector(long period, long delay, int resolution) {
            this.period = period;
            this.delay = delay;
            this.resolution = resolution;
            this.createdMillis = SimpleHashWheelTimer.now(resolution);
        }

        @Override
        public Object getObject() {
            return this.period;
        }

        @Override
        public boolean matches(Long key) {
            long now = key;
            long period = (long)(Math.ceil((now - this.createdMillis) / (long)this.resolution) * (double)this.resolution);
            return period >= this.delay && period % this.period == 0L;
        }

        @Override
        public HeaderResolver getHeaderResolver() {
            return null;
        }
    }
}

