/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn.timer;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactor.fn.Consumer;
import reactor.fn.timer.SimpleHashWheelTimer;
import reactor.fn.timer.Timer;

public abstract class TimeUtils {
    private static final int DEFAULT_RESOLUTION = 100;
    private static final AtomicLong now = new AtomicLong();
    private static Timer timer;

    protected TimeUtils() {
    }

    public static long approxCurrentTimeMillis() {
        TimeUtils.getTimer();
        return now.get();
    }

    public static void setTimer(Timer timer) {
        timer.schedule(new Consumer<Long>(){

            @Override
            public void accept(Long aLong) {
                now.set(System.currentTimeMillis());
            }
        }, 100L, TimeUnit.MILLISECONDS, 100L);
        now.set(System.currentTimeMillis());
        TimeUtils.timer = timer;
    }

    public static Timer getTimer() {
        if (null == timer) {
            TimeUtils.setTimer(new SimpleHashWheelTimer(100));
        }
        return timer;
    }
}

