/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.util.List;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;

public abstract class Codec<SRC, IN, OUT>
implements Function<OUT, SRC> {
    public static final byte DEFAULT_DELIMITER = 0;
    protected final Byte delimiter;

    public Codec() {
        this((byte)0);
    }

    public Codec(Byte delimiter) {
        this.delimiter = delimiter;
    }

    public Function<SRC, IN> decoder() {
        return this.decoder(null);
    }

    public abstract Function<SRC, IN> decoder(Consumer<IN> var1);

    public Function<OUT, SRC> encoder() {
        return this;
    }

    protected IN doDelimitedBufferDecode(Consumer<IN> decoderCallback, Buffer buffer) {
        if (this.delimiter != null) {
            List<Buffer.View> views = buffer.split(this.delimiter.byteValue());
            int viewCount = views.size();
            if (viewCount == 0) {
                return this.invokeCallbackOrReturn(decoderCallback, this.doBufferDecode(buffer));
            }
            for (Buffer.View view : views) {
                IN in = this.invokeCallbackOrReturn(decoderCallback, this.doBufferDecode(view.get()));
                if (in == null) continue;
                return in;
            }
            return null;
        }
        return this.invokeCallbackOrReturn(decoderCallback, this.doBufferDecode(buffer));
    }

    private IN invokeCallbackOrReturn(Consumer<IN> consumer, IN v) {
        if (consumer != null) {
            consumer.accept(v);
            return null;
        }
        return v;
    }

    protected IN doBufferDecode(Buffer buffer) {
        return null;
    }

    protected Buffer addDelimiterIfAny(Buffer buffer) {
        if (this.delimiter != null) {
            return buffer.append(this.delimiter).flip();
        }
        return buffer;
    }
}

