/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.util.List;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;

public class DelimitedCodec<IN, OUT>
extends Codec<Buffer, IN, OUT> {
    private final Codec<Buffer, IN, OUT> delegate;
    private final boolean stripDelimiter;

    public DelimitedCodec(Codec<Buffer, IN, OUT> delegate) {
        this(10, true, delegate);
    }

    public DelimitedCodec(boolean stripDelimiter, Codec<Buffer, IN, OUT> delegate) {
        this(10, stripDelimiter, delegate);
    }

    public DelimitedCodec(byte delimiter, boolean stripDelimiter, Codec<Buffer, IN, OUT> delegate) {
        super(delimiter);
        this.stripDelimiter = stripDelimiter;
        this.delegate = delegate;
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        return new DelimitedDecoder(next);
    }

    @Override
    public Buffer apply(OUT out) {
        Buffer buffer = new Buffer();
        Buffer encoded = (Buffer)this.delegate.apply(out);
        if (null != encoded && encoded.remaining() > 0) {
            buffer.append(encoded).append(this.delimiter);
        }
        return buffer.flip();
    }

    private class DelimitedDecoder
    implements Function<Buffer, IN> {
        private final Function<Buffer, IN> decoder;

        DelimitedDecoder(Consumer<IN> next) {
            this.decoder = DelimitedCodec.this.delegate.decoder(next);
        }

        @Override
        public IN apply(Buffer bytes) {
            if (bytes.remaining() == 0) {
                return null;
            }
            List<Buffer.View> views = bytes.split(DelimitedCodec.this.delimiter.byteValue(), DelimitedCodec.this.stripDelimiter);
            int limit = bytes.limit();
            int position = bytes.position();
            for (Buffer.View view : views) {
                Buffer b = view.get();
                this.decoder.apply(b);
            }
            bytes.limit(limit);
            bytes.position(position);
            return null;
        }
    }
}

