/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;

public class JavaSerializationCodec<T>
extends Codec<Buffer, T, T> {
    @Override
    public Function<Buffer, T> decoder(Consumer<T> next) {
        return new Decoder(next);
    }

    @Override
    public Buffer apply(T t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(t);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return Buffer.wrap(baos.toByteArray());
    }

    private class Decoder
    implements Function<Buffer, T> {
        private final Consumer<T> next;

        private Decoder(Consumer<T> next) {
            this.next = next;
        }

        @Override
        public T apply(Buffer buff) {
            if (buff.remaining() <= 0) {
                return null;
            }
            try {
                Object obj = new ObjectInputStream(new ByteArrayInputStream(buff.asBytes())).readObject();
                if (null != this.next) {
                    this.next.accept(obj);
                    return null;
                }
                return obj;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

