/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;

public class StringCodec
extends Codec<Buffer, String, String> {
    private final Charset utf8 = Charset.forName("UTF-8");
    private final CharsetDecoder decoder = this.utf8.newDecoder();
    private final CharsetEncoder encoder = this.utf8.newEncoder();

    public StringCodec() {
        this(null);
    }

    public StringCodec(Byte delimiter) {
        super(delimiter);
    }

    @Override
    public Function<Buffer, String> decoder(Consumer<String> next) {
        return new StringDecoder(next);
    }

    @Override
    protected String doBufferDecode(Buffer buffer) {
        try {
            return this.decoder.decode(buffer.byteBuffer()).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Buffer apply(String s) {
        try {
            ByteBuffer bb = this.encoder.encode(CharBuffer.wrap(s));
            if (this.delimiter != null) {
                return this.addDelimiterIfAny(new Buffer().append(bb));
            }
            return new Buffer(bb);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private class StringDecoder
    implements Function<Buffer, String> {
        private final Consumer<String> next;

        private StringDecoder(Consumer<String> next) {
            this.next = next;
        }

        @Override
        public String apply(Buffer bytes) {
            return StringCodec.this.doDelimitedBufferDecode(this.next, bytes);
        }
    }
}

