/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.queue;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import reactor.io.queue.QueuePersistor;

public class InMemoryQueuePersistor<T>
implements QueuePersistor<T> {
    private final Map<Long, T> objects;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong currentId = new AtomicLong();

    public InMemoryQueuePersistor() {
        this.objects = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public long lastId() {
        return this.currentId.get();
    }

    @Override
    public long size() {
        return this.counter.get();
    }

    @Override
    public boolean hasNext() {
        return this.counter.get() <= 0L;
    }

    @Override
    public Iterator<T> iterator() {
        return this.objects.values().iterator();
    }

    @Override
    public Long offer(@Nonnull T obj) {
        Long id = this.counter.getAndIncrement();
        this.objects.put(id, obj);
        return id;
    }

    @Override
    public Long offerAll(@Nonnull Collection<T> t) {
        Long last = null;
        for (T v : t) {
            last = this.offer(v);
        }
        return last;
    }

    @Override
    public T get(Long idx) {
        return this.objects.get(idx);
    }

    @Override
    public T remove() {
        Long id = this.currentId.getAndIncrement();
        this.counter.getAndDecrement();
        return this.objects.remove(id);
    }

    @Override
    public void close() {
    }

    public Map<Long, T> refMap() {
        return this.objects;
    }
}

