/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.queue.spec;

import java.io.IOException;
import net.openhft.chronicle.ChronicleQueueBuilder;
import reactor.fn.Supplier;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.queue.IndexedChronicleQueuePersistor;
import reactor.io.queue.PersistentQueue;

public class PersistentQueueSpec<T>
implements Supplier<PersistentQueue<T>> {
    public static String DEFAULT_BASE_PATH = System.getProperty("java.io.tmpdir") + "/persistent-queue";
    private String basePath = DEFAULT_BASE_PATH;
    private boolean clearOnStart = false;
    private boolean deleteOnExit = false;
    private Codec<Buffer, T, T> codec;
    private ChronicleQueueBuilder.IndexedChronicleQueueBuilder config = ChronicleQueueBuilder.indexed((String)this.basePath);

    public PersistentQueueSpec<T> codec(Codec<Buffer, T, T> codec) {
        this.codec = codec;
        return this;
    }

    public PersistentQueueSpec<T> basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public PersistentQueueSpec<T> clearOnStart(boolean clearOnStart) {
        this.clearOnStart = clearOnStart;
        return this;
    }

    public PersistentQueueSpec<T> deleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
        return this;
    }

    public PersistentQueueSpec<T> cacheLineSize(int size) {
        this.config.cacheLineSize(size);
        return this;
    }

    public PersistentQueueSpec<T> dataBlockSize(int size) {
        this.config.dataBlockSize(size);
        return this;
    }

    public PersistentQueueSpec<T> messageCapacity(int size) {
        this.config.messageCapacity(size);
        return this;
    }

    public PersistentQueueSpec<T> sync(boolean synchronousMode) {
        this.config.synchronous(synchronousMode);
        return this;
    }

    public PersistentQueueSpec<T> indexBlockSize(int excerpts) {
        this.config.indexBlockSize(excerpts);
        return this;
    }

    @Override
    public PersistentQueue<T> get() {
        try {
            return new PersistentQueue<T>(new IndexedChronicleQueuePersistor<T>(this.basePath, this.codec, this.clearOnStart, this.deleteOnExit, (ChronicleQueueBuilder)this.config));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

