/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.stream;

import java.io.IOException;
import java.util.Map;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.tools.ChronicleTools;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.queue.spec.PersistentQueueSpec;
import reactor.io.stream.ChronicleReaderStream;
import reactor.rx.stream.MapStream;

public final class ChronicleStream<K, V>
extends ChronicleReaderStream<K, V> {
    private static final int DEFAULT_MESSAGE_SIZE_HINT = 0x100000;
    private final int messageSizeHint;

    public ChronicleStream(String name) throws IOException {
        this(name, 0x100000);
    }

    public ChronicleStream(String name, int messageSizeHint) throws IOException {
        this(name, messageSizeHint, ChronicleQueueBuilder.indexed((String)PersistentQueueSpec.DEFAULT_BASE_PATH, (String)name).build());
    }

    public ChronicleStream(String name, int messageSizeHint, Chronicle chronicle) {
        this(name, messageSizeHint, chronicle, null, null);
    }

    public ChronicleStream(String name, int messageSizeHint, Chronicle chronicle, Codec<Buffer, K, K> keyCodec, Codec<Buffer, V, V> valueCodec) {
        super(name, chronicle, keyCodec, valueCodec);
        this.messageSizeHint = messageSizeHint;
    }

    @Override
    public V put(K key, V value) {
        V previous = this.localCache.put(key, value);
        if (this.sameOrNotEqual(previous, value)) {
            this.writePut(key, previous, value);
        }
        return previous;
    }

    public void deleteOnExit() {
        ChronicleTools.deleteOnExit((String)this.chronicle.name());
    }

    protected boolean sameOrNotEqual(V previous, V value) {
        return previous == value || previous == null || !previous.equals(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.writePutAll(m);
    }

    @Override
    public V remove(Object key) {
        Object value = this.localCache.remove(key);
        if (value != null) {
            this.writeRemove(key);
        }
        return value;
    }

    @Override
    public int size() {
        return this.localCache.size();
    }

    @Override
    public void clear() {
        ExcerptAppender writeExcerpt = this.getExcerpt(16, MapStream.Operation.clear);
        writeExcerpt.finish();
    }

    protected void writeRemove(Object key) {
        ExcerptAppender excerpt = this.getExcerpt(this.messageSizeHint, MapStream.Operation.remove);
        this.writeKey(excerpt, key);
        excerpt.finish();
    }

    protected void writePut(K key, V previous, V value) {
        ExcerptAppender excerpt = this.getExcerpt(this.messageSizeHint, MapStream.Operation.put);
        this.writeKey(excerpt, key);
        this.writeValue(excerpt, value);
        excerpt.finish();
    }

    protected void writePutAll(Map<? extends K, ? extends V> m) {
        ExcerptAppender excerpt = this.getExcerpt(m.size() * this.messageSizeHint, MapStream.Operation.putAll);
        long pos = excerpt.position();
        excerpt.writeInt(0);
        int count = 0;
        for (Map.Entry<K, V> entry : m.entrySet()) {
            V value;
            K key = entry.getKey();
            V previous = this.localCache.put(key, value = entry.getValue());
            if (!this.sameOrNotEqual(previous, value)) continue;
            this.writeKey(excerpt, key);
            this.writeValue(excerpt, value);
            ++count;
        }
        excerpt.writeInt(pos, count);
        excerpt.finish();
    }

    private void writeValue(ExcerptAppender excerpt, V value) {
        if (this.valueCodec == null) {
            excerpt.writeObject(value);
        } else {
            Buffer buff = (Buffer)this.valueCodec.apply(value);
            int size = buff.remaining();
            excerpt.writeInt(size);
            excerpt.write(buff.byteBuffer());
        }
    }

    private void writeKey(ExcerptAppender excerpt, K key) {
        if (this.keyCodec == null) {
            excerpt.writeObject(key);
        } else {
            Buffer buff = (Buffer)this.keyCodec.apply(key);
            int size = buff.remaining();
            excerpt.writeInt(size);
            excerpt.write(buff.byteBuffer());
        }
    }

    private ExcerptAppender getExcerpt(int maxSize, MapStream.Operation event) {
        ExcerptAppender writeExcerpt;
        try {
            writeExcerpt = this.chronicle.createAppender();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        writeExcerpt.startExcerpt((long)(maxSize + 2 + event.name().length()));
        writeExcerpt.writeEnum((Object)event);
        return writeExcerpt;
    }
}

