/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.dispatch.TailRecurseDispatcher;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.rx.Promises;
import reactor.rx.Stream;
import reactor.rx.StreamUtils;
import reactor.rx.action.Action;
import reactor.rx.action.support.NonBlocking;
import reactor.rx.broadcast.BehaviorBroadcaster;
import reactor.rx.subscription.PushSubscription;

public class Promise<O>
implements Supplier<O>,
Processor<O, O>,
Consumer<O>,
NonBlocking {
    private final ReentrantLock lock = new ReentrantLock();
    private final long defaultTimeout;
    private final Condition pendingCondition;
    private final Dispatcher dispatcher;
    private final Environment environment;
    Action<O, O> outboundStream;
    FinalState finalState = null;
    private O value;
    private Throwable error;
    private boolean hasBlockers = false;
    protected Subscription subscription;

    public Promise() {
        this(SynchronousDispatcher.INSTANCE, null);
    }

    public Promise(Dispatcher dispatcher, @Nullable Environment env) {
        this.dispatcher = dispatcher;
        this.environment = env;
        this.defaultTimeout = env != null ? env.getProperty("reactor.await.defaultTimeout", Long.class, 30000L) : 30000L;
        this.pendingCondition = this.lock.newCondition();
    }

    public Promise(O value, Dispatcher dispatcher, @Nullable Environment env) {
        this(dispatcher, env);
        this.finalState = FinalState.COMPLETE;
        this.value = value;
    }

    public Promise(Throwable error, Dispatcher dispatcher, @Nullable Environment env) {
        this(dispatcher, env);
        this.finalState = FinalState.ERROR;
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<O> onComplete(final @Nonnull Consumer<Promise<O>> onComplete) {
        if (this.dispatcher == SynchronousDispatcher.INSTANCE || TailRecurseDispatcher.class == this.dispatcher.getClass()) {
            this.lock.lock();
            try {
                if (this.finalState == FinalState.ERROR) {
                    onComplete.accept(this);
                    Promise promise = Promises.error(this.environment, this.dispatcher, this.error);
                    return promise;
                }
                if (this.finalState == FinalState.COMPLETE) {
                    onComplete.accept(this);
                    Promise<O> promise = Promises.success(this.environment, this.dispatcher, this.value);
                    return promise;
                }
            }
            catch (Throwable t) {
                Promise promise = Promises.error(this.environment, this.dispatcher, t);
                return promise;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.stream().lift(new Supplier<Action<O, O>>(){

            @Override
            public Action<O, O> get() {
                return new Action<O, O>(){

                    @Override
                    protected void doNext(O ev) {
                        onComplete.accept(Promise.this);
                        this.broadcastNext(ev);
                        this.broadcastComplete();
                    }

                    @Override
                    protected void doError(Throwable ev) {
                        onComplete.accept(Promise.this);
                        this.broadcastError(ev);
                    }
                };
            }
        }).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<O> onSuccess(@Nonnull Consumer<O> onSuccess) {
        if (this.dispatcher == SynchronousDispatcher.INSTANCE || TailRecurseDispatcher.class == this.dispatcher.getClass()) {
            this.lock.lock();
            try {
                if (this.finalState == FinalState.COMPLETE) {
                    if (this.value != null) {
                        onSuccess.accept(this.value);
                    }
                    Promise promise = this;
                    return promise;
                }
            }
            catch (Throwable t) {
                Promise promise = Promises.error(this.environment, this.dispatcher, t);
                return promise;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.stream().observe(onSuccess).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Promise<V> map(@Nonnull Function<? super O, V> transformation) {
        if (this.dispatcher == SynchronousDispatcher.INSTANCE || TailRecurseDispatcher.class == this.dispatcher.getClass()) {
            this.lock.lock();
            try {
                if (this.finalState == FinalState.ERROR) {
                    Promise promise = Promises.error(this.environment, this.dispatcher, this.error);
                    return promise;
                }
                if (this.finalState == FinalState.COMPLETE) {
                    Promise<Object> promise = Promises.success(this.environment, this.dispatcher, this.value != null ? (Object)transformation.apply((O)this.value) : null);
                    return promise;
                }
            }
            catch (Throwable t) {
                Promise promise = Promises.error(this.environment, this.dispatcher, t);
                return promise;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.stream().map(transformation).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Promise<V> flatMap(@Nonnull Function<? super O, ? extends Publisher<? extends V>> transformation) {
        if (this.dispatcher == SynchronousDispatcher.INSTANCE || TailRecurseDispatcher.class == this.dispatcher.getClass()) {
            this.lock.lock();
            try {
                if (this.finalState == FinalState.ERROR) {
                    Promise promise = Promises.error(this.environment, this.dispatcher, this.error);
                    return promise;
                }
                if (this.finalState == FinalState.COMPLETE) {
                    if (this.value != null) {
                        Promise successPromise = Promises.ready(this.environment, this.dispatcher);
                        transformation.apply(this.value).subscribe(successPromise);
                        Promise promise = successPromise;
                        return promise;
                    }
                    Promise<Object> successPromise = Promises.success(this.environment, this.dispatcher, null);
                    return successPromise;
                }
            }
            catch (Throwable t) {
                Promise promise = Promises.error(this.environment, this.dispatcher, t);
                return promise;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.stream().flatMap(transformation).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<O> onError(@Nonnull Consumer<Throwable> onError) {
        if (this.dispatcher == SynchronousDispatcher.INSTANCE || TailRecurseDispatcher.class == this.dispatcher.getClass()) {
            this.lock.lock();
            try {
                if (this.finalState == FinalState.ERROR) {
                    onError.accept(this.error);
                    Promise promise = this;
                    return promise;
                }
                if (this.finalState == FinalState.COMPLETE) {
                    Promise promise = this;
                    return promise;
                }
            }
            catch (Throwable t) {
                Promise promise = Promises.error(this.environment, this.dispatcher, t);
                return promise;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.stream().when(Throwable.class, onError).next();
    }

    public boolean isComplete() {
        this.lock.lock();
        try {
            boolean bl = this.finalState != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPending() {
        this.lock.lock();
        try {
            boolean bl = this.finalState == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isSuccess() {
        this.lock.lock();
        try {
            boolean bl = this.finalState == FinalState.COMPLETE;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isError() {
        this.lock.lock();
        try {
            boolean bl = this.finalState == FinalState.ERROR;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean awaitSuccess() throws InterruptedException {
        return this.awaitSuccess(this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    public boolean awaitSuccess(long timeout, TimeUnit unit) throws InterruptedException {
        this.await(timeout, unit);
        return this.isSuccess();
    }

    public O await() throws InterruptedException {
        return this.await(this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O await(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.isPending()) {
            return this.get();
        }
        this.lock.lock();
        try {
            this.hasBlockers = true;
            if (timeout >= 0L) {
                long msTimeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
                long endTime = System.currentTimeMillis() + msTimeout;
                while (this.finalState == null && System.currentTimeMillis() < endTime) {
                    this.pendingCondition.await(200L, TimeUnit.MILLISECONDS);
                }
            } else {
                while (this.finalState == null) {
                    this.pendingCondition.await(200L, TimeUnit.MILLISECONDS);
                }
            }
        }
        finally {
            this.hasBlockers = false;
            this.lock.unlock();
        }
        return this.get();
    }

    public O poll() {
        return this.poll(this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    public O poll(long timeout, TimeUnit unit) {
        try {
            return this.await(timeout, unit);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public O get() {
        this.lock.lock();
        try {
            if (this.finalState == FinalState.COMPLETE) {
                O o = this.value;
                return o;
            }
            if (this.finalState == FinalState.ERROR) {
                if (RuntimeException.class.isInstance(this.error)) {
                    throw (RuntimeException)this.error;
                }
                throw new RuntimeException(this.error);
            }
            O o = null;
            return o;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Throwable reason() {
        this.lock.lock();
        try {
            Throwable throwable = this.error;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Stream<O> stream() {
        this.lock.lock();
        try {
            if (this.outboundStream == null) {
                this.outboundStream = BehaviorBroadcaster.first(this.value, this.environment, this.dispatcher).capacity(1L);
                if (this.isSuccess()) {
                    this.outboundStream.onComplete();
                } else if (this.isError()) {
                    this.outboundStream.onError(this.error);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.outboundStream;
    }

    public void subscribe(Subscriber<? super O> subscriber) {
        this.stream().subscribe(subscriber);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(O element) {
        this.valueAccepted(element);
    }

    public void onComplete() {
        this.completeAccepted();
    }

    public void onError(Throwable cause) {
        this.errorAccepted(cause);
    }

    @Override
    public void accept(O o) {
        this.valueAccepted(o);
    }

    public StreamUtils.StreamVisitor debug() {
        Action<?, ?> debugged = this.findOldestStream();
        if (this.subscription == null || debugged == null) {
            return this.outboundStream != null ? this.outboundStream.debug() : null;
        }
        return debugged.debug();
    }

    public Action<?, ?> findOldestStream() {
        PushSubscription sub = this.subscription;
        Action that = null;
        while (sub != null && PushSubscription.class.isAssignableFrom(sub.getClass()) && ((PushSubscription)sub).getPublisher() != null && Action.class.isAssignableFrom(((PushSubscription)sub).getPublisher().getClass())) {
            that = (Action)((PushSubscription)sub).getPublisher();
            sub = that.getSubscription();
        }
        return that;
    }

    protected void errorAccepted(Throwable error) {
        this.lock.lock();
        try {
            if (!this.isPending()) {
                if (this.isSuccess()) {
                    throw new IllegalStateException(this.finalState.toString() + " : " + this.value, error);
                }
                throw new IllegalStateException(this.finalState.toString(), error);
            }
            this.error = error;
            this.finalState = FinalState.ERROR;
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            if (this.outboundStream != null) {
                this.outboundStream.onError(error);
            }
            if (this.hasBlockers) {
                this.pendingCondition.signalAll();
                this.hasBlockers = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void valueAccepted(O value) {
        this.lock.lock();
        try {
            if (!this.isPending()) {
                if (this.isError()) {
                    throw new IllegalStateException(value + " >> " + this.finalState.toString(), this.error);
                }
                if (this.isSuccess()) {
                    throw new IllegalStateException(value + " >> " + this.finalState.toString() + " : " + value);
                }
                throw new IllegalStateException(value + " >> " + this.finalState.toString());
            }
            this.value = value;
            this.finalState = FinalState.COMPLETE;
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            if (this.outboundStream != null) {
                this.outboundStream.onNext(value);
                this.outboundStream.onComplete();
            }
            if (this.hasBlockers) {
                this.pendingCondition.signalAll();
                this.hasBlockers = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void completeAccepted() {
        this.lock.lock();
        try {
            if (this.isPending()) {
                this.valueAccepted(null);
            }
            if (this.subscription != null) {
                this.subscription.cancel();
                this.subscription = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
        return true;
    }

    @Override
    public long getCapacity() {
        return 1L;
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = "Promise{value=" + this.value + (this.finalState != null ? ", state=" + (Object)((Object)this.finalState) : "") + ", error=" + this.error + '}';
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum FinalState {
        ERROR,
        COMPLETE;

    }
}

