/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx;

import java.util.Arrays;
import java.util.List;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.support.Assert;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.fn.tuple.Tuple;
import reactor.fn.tuple.Tuple2;
import reactor.fn.tuple.Tuple3;
import reactor.fn.tuple.Tuple4;
import reactor.fn.tuple.Tuple5;
import reactor.fn.tuple.Tuple6;
import reactor.fn.tuple.Tuple7;
import reactor.fn.tuple.Tuple8;
import reactor.rx.Promise;
import reactor.rx.action.combination.MergeAction;
import reactor.rx.stream.SupplierStream;

public final class Promises {
    public static <T> Promise<T> prepare() {
        return Promises.ready(null, SynchronousDispatcher.INSTANCE);
    }

    public static <T> Promise<T> prepare(Environment env) {
        return Promises.ready(env, env.getDefaultDispatcher());
    }

    public static <T> Promise<T> ready(Environment env, Dispatcher dispatcher) {
        return new Promise(dispatcher, env);
    }

    public static <T> Promise<T> syncTask(Supplier<T> supplier) {
        return Promises.task(null, SynchronousDispatcher.INSTANCE, supplier);
    }

    public static <T> Promise<T> task(Environment env, Supplier<T> supplier) {
        return Promises.task(env, env.getDefaultDispatcher(), supplier);
    }

    public static <T> Promise<T> task(Environment env, Dispatcher dispatcher, Supplier<T> supplier) {
        SupplierStream supplierStream = new SupplierStream(supplier);
        Promise promise = new Promise(dispatcher, env);
        supplierStream.subscribe(promise);
        return promise;
    }

    public static <T> Promise<T> success(T value) {
        return Promises.success(null, SynchronousDispatcher.INSTANCE, value);
    }

    public static <T> Promise<T> success(Environment env, T value) {
        return Promises.success(env, env.getDefaultDispatcher(), value);
    }

    public static <T> Promise<T> success(Environment env, Dispatcher dispatcher, T value) {
        return new Promise<T>(value, dispatcher, env);
    }

    public static <T> Promise<T> error(Throwable error) {
        return Promises.error(null, SynchronousDispatcher.INSTANCE, error);
    }

    public static <T> Promise<T> error(Environment env, Throwable error) {
        return Promises.error(env, env.getDefaultDispatcher(), error);
    }

    public static <T> Promise<T> error(Environment env, Dispatcher dispatcher, Throwable error) {
        return new Promise(error, dispatcher, env);
    }

    public static <T1, T2> Promise<Tuple2<T1, T2>> when(Promise<T1> p1, Promise<T2> p2) {
        return Promises.multiWhen(p1, p2).map(new Function<List<Object>, Tuple2<T1, T2>>(){

            @Override
            public Tuple2<T1, T2> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1));
            }
        });
    }

    public static <T1, T2, T3> Promise<Tuple3<T1, T2, T3>> when(Promise<T1> p1, Promise<T2> p2, Promise<T3> p3) {
        return Promises.multiWhen(p1, p2, p3).map(new Function<List<Object>, Tuple3<T1, T2, T3>>(){

            @Override
            public Tuple3<T1, T2, T3> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1), objects.get(2));
            }
        });
    }

    public static <T1, T2, T3, T4> Promise<Tuple4<T1, T2, T3, T4>> when(Promise<T1> p1, Promise<T2> p2, Promise<T3> p3, Promise<T4> p4) {
        return Promises.multiWhen(p1, p2, p3, p4).map(new Function<List<Object>, Tuple4<T1, T2, T3, T4>>(){

            @Override
            public Tuple4<T1, T2, T3, T4> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1), objects.get(2), objects.get(3));
            }
        });
    }

    public static <T1, T2, T3, T4, T5> Promise<Tuple5<T1, T2, T3, T4, T5>> when(Promise<T1> p1, Promise<T2> p2, Promise<T3> p3, Promise<T4> p4, Promise<T5> p5) {
        return Promises.multiWhen(p1, p2, p3, p4, p5).map(new Function<List<Object>, Tuple5<T1, T2, T3, T4, T5>>(){

            @Override
            public Tuple5<T1, T2, T3, T4, T5> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1), objects.get(2), objects.get(3), objects.get(4));
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6> Promise<Tuple6<T1, T2, T3, T4, T5, T6>> when(Promise<T1> p1, Promise<T2> p2, Promise<T3> p3, Promise<T4> p4, Promise<T5> p5, Promise<T6> p6) {
        return Promises.multiWhen(p1, p2, p3, p4, p5, p6).map(new Function<List<Object>, Tuple6<T1, T2, T3, T4, T5, T6>>(){

            @Override
            public Tuple6<T1, T2, T3, T4, T5, T6> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1), objects.get(2), objects.get(3), objects.get(4), objects.get(5));
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Promise<Tuple7<T1, T2, T3, T4, T5, T6, T7>> when(Promise<T1> p1, Promise<T2> p2, Promise<T3> p3, Promise<T4> p4, Promise<T5> p5, Promise<T6> p6, Promise<T7> p7) {
        return Promises.multiWhen(p1, p2, p3, p4, p5, p6, p7).map(new Function<List<Object>, Tuple7<T1, T2, T3, T4, T5, T6, T7>>(){

            @Override
            public Tuple7<T1, T2, T3, T4, T5, T6, T7> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1), objects.get(2), objects.get(3), objects.get(4), objects.get(5), objects.get(6));
            }
        });
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Promise<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> when(Promise<T1> p1, Promise<T2> p2, Promise<T3> p3, Promise<T4> p4, Promise<T5> p5, Promise<T6> p6, Promise<T7> p7, Promise<T8> p8) {
        return Promises.multiWhen(p1, p2, p3, p4, p5, p6, p7, p8).map(new Function<List<Object>, Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>>(){

            @Override
            public Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> apply(List<Object> objects) {
                return Tuple.of(objects.get(0), objects.get(1), objects.get(2), objects.get(3), objects.get(4), objects.get(5), objects.get(6), objects.get(7));
            }
        });
    }

    public static <T> Promise<List<T>> when(List<? extends Promise<T>> promises) {
        Assert.isTrue(promises.size() > 0, "Must aggregate at least one promise");
        return new MergeAction((Dispatcher)SynchronousDispatcher.INSTANCE, promises).buffer(promises.size()).next();
    }

    public static <T> Promise<T> any(Promise<T> ... promises) {
        return Promises.any(Arrays.asList(promises));
    }

    public static <T> Promise<T> any(List<? extends Promise<T>> promises) {
        Assert.isTrue(promises.size() > 0, "Must aggregate at least one promise");
        MergeAction mergeAction = new MergeAction((Dispatcher)SynchronousDispatcher.INSTANCE, promises);
        return mergeAction.next();
    }

    private static <T> Promise<List<T>> multiWhen(Promise<T> ... promises) {
        return Promises.when(Arrays.asList(promises));
    }
}

