/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Subscription;
import reactor.fn.Consumer;
import reactor.rx.Promise;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.action.CompositeAction;
import reactor.rx.action.aggregation.WindowAction;
import reactor.rx.action.combination.DynamicMergeAction;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.action.combination.FanInSubscription;
import reactor.rx.action.combination.SwitchAction;
import reactor.rx.action.error.RetryWhenAction;
import reactor.rx.action.support.SerializedSubscriber;
import reactor.rx.action.transformation.GroupByAction;
import reactor.rx.stream.GroupedStream;
import reactor.rx.subscription.FanOutSubscription;
import reactor.rx.subscription.PushSubscription;

public abstract class StreamUtils {
    public static <O> StreamVisitor browse(Stream<O> composable) {
        return StreamUtils.browse(composable, new DebugVisitor());
    }

    public static <O> StreamVisitor browse(Stream<O> composable, DebugVisitor visitor) {
        StreamVisitor explorer = new StreamVisitor(visitor);
        explorer.accept(composable);
        return explorer;
    }

    private static final class StreamKey
    implements Serializable {
        private final Stream<?> stream;
        private final Object key;

        public StreamKey(Stream<?> composable) {
            this.stream = composable;
            this.key = GroupedStream.class.isAssignableFrom(this.stream.getClass()) ? ((GroupedStream)this.stream).key() : (composable.getClass().getSimpleName().isEmpty() ? composable.getClass().getName() + "" + composable : composable.getClass().getSimpleName().replaceAll("Action", ""));
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreamKey streamKey = (StreamKey)o;
            return this.stream.equals(streamKey.stream);
        }

        public int hashCode() {
            return this.stream.hashCode();
        }
    }

    public static class StreamVisitor
    implements Consumer<Stream<?>> {
        private final Set<Object> references = new HashSet<Object>();
        private final Map<Object, Object> streamTree = new HashMap<Object, Object>();
        private final DebugVisitor debugVisitor;

        public StreamVisitor(DebugVisitor debugVisitor) {
            this.debugVisitor = debugVisitor;
        }

        @Override
        public void accept(Stream<?> composable) {
            List<Object> downstreamTree = null;
            if (Action.class.isAssignableFrom(composable.getClass())) {
                this.parseUpstream((Action)composable, downstreamTree);
            }
            this.parseComposable(composable, downstreamTree);
        }

        private void parseUpstream(Action<?, ?> action, List<Object> downstreamTree) {
            Stream<?> publisher;
            if (action.getSubscription() != null && PushSubscription.class.isAssignableFrom(action.getSubscription().getClass()) && (publisher = action.getSubscription().getPublisher()) != null && Stream.class.isAssignableFrom(publisher.getClass())) {
                this.parseComposable(publisher, downstreamTree);
            }
        }

        private <O> void parseComposable(Stream<O> composable, List<Object> streamTree) {
            ArrayList<Object> nextLevelNestedStreams;
            boolean hasRenderedSpecial;
            if (composable == null) {
                return;
            }
            HashMap<String, Object> freshNestedStreams = new HashMap<String, Object>();
            freshNestedStreams.put("id", new StreamKey(composable).toString());
            if (streamTree != null) {
                streamTree.add(freshNestedStreams);
            }
            if (this.references.contains(composable)) {
                return;
            }
            freshNestedStreams.put("info", composable.toString());
            this.references.add(composable);
            if (this.debugVisitor != null) {
                this.debugVisitor.accept(composable);
                this.debugVisitor.d += 2;
            }
            boolean bl = hasRenderedSpecial = this.renderWindow(composable, nextLevelNestedStreams = new ArrayList<Object>()) || this.renderGroupBy(composable, nextLevelNestedStreams) || this.renderSwitch(composable, nextLevelNestedStreams) || this.renderDynamicMerge(composable, nextLevelNestedStreams) || this.renderMerge(composable, nextLevelNestedStreams) || this.renderRetryWhen(composable, nextLevelNestedStreams) || this.renderCombine(composable, nextLevelNestedStreams);
            if (!nextLevelNestedStreams.isEmpty()) {
                freshNestedStreams.put("boundTo", nextLevelNestedStreams);
            }
            if (this.debugVisitor != null) {
                this.debugVisitor.d -= 2;
            }
            nextLevelNestedStreams = new ArrayList();
            this.loopSubscriptions(composable.downstreamSubscription(), nextLevelNestedStreams);
            if (!nextLevelNestedStreams.isEmpty()) {
                freshNestedStreams.put("to", nextLevelNestedStreams);
            }
            if (streamTree == null) {
                this.streamTree.putAll(freshNestedStreams);
            }
        }

        private <E extends Subscription> void loopSubscriptions(E operation, final List<Object> streamTree) {
            if (operation == null) {
                return;
            }
            final boolean multicast = FanOutSubscription.class.isAssignableFrom(operation.getClass());
            Consumer procedure = new Consumer<E>(){

                @Override
                public void accept(E registration) {
                    Object subscriber = null;
                    if (PushSubscription.class.isAssignableFrom(registration.getClass())) {
                        subscriber = ((PushSubscription)registration).getSubscriber();
                    }
                    if (subscriber != null && SerializedSubscriber.class.isAssignableFrom(subscriber.getClass())) {
                        subscriber = ((SerializedSubscriber)subscriber).delegate();
                    }
                    if (subscriber != null) {
                        if (StreamVisitor.this.debugVisitor != null && multicast) {
                            ++((StreamVisitor)StreamVisitor.this).debugVisitor.d;
                            StreamVisitor.this.debugVisitor.newMulticastLine(((StreamVisitor)StreamVisitor.this).debugVisitor.d);
                        }
                        if (Stream.class.isAssignableFrom(subscriber.getClass())) {
                            StreamVisitor.this.parseComposable((Stream)subscriber, streamTree);
                        } else {
                            HashMap<String, Object> wrappedSubscriber = new HashMap<String, Object>();
                            if (StreamVisitor.this.debugVisitor != null) {
                                StreamVisitor.this.debugVisitor.newLine(((StreamVisitor)StreamVisitor.this).debugVisitor.d);
                                StreamVisitor.this.debugVisitor.appender.append(subscriber).append(registration);
                            }
                            if (Promise.class.isAssignableFrom(subscriber.getClass())) {
                                ArrayList wrappedStream = new ArrayList();
                                wrappedSubscriber.put("info", subscriber.toString());
                                if (((Promise)subscriber).finalState != null) {
                                    wrappedSubscriber.put("state", (Object)((Promise)subscriber).finalState);
                                }
                                StreamVisitor.this.parseComposable(((Promise)subscriber).outboundStream, wrappedStream);
                            } else {
                                wrappedSubscriber.put("info", subscriber.toString());
                            }
                            streamTree.add(wrappedSubscriber);
                        }
                        if (StreamVisitor.this.debugVisitor != null && multicast) {
                            --((StreamVisitor)StreamVisitor.this).debugVisitor.d;
                            StreamVisitor.this.debugVisitor.newLine(((StreamVisitor)StreamVisitor.this).debugVisitor.d, false);
                        }
                    }
                }
            };
            if (multicast) {
                ((FanOutSubscription)operation).forEach(procedure);
            } else {
                procedure.accept(operation);
            }
        }

        private <O> boolean renderSwitch(Stream<O> consumer, List<Object> streamTree) {
            if (SwitchAction.class.isAssignableFrom(consumer.getClass())) {
                SwitchAction operation = (SwitchAction)consumer;
                SwitchAction.SwitchSubscriber switchSubscriber = operation.getSwitchSubscriber();
                if (switchSubscriber != null && switchSubscriber.getSubscription() != null) {
                    this.loopSubscriptions(switchSubscriber.getSubscription(), streamTree);
                }
                return true;
            }
            return false;
        }

        private <O> boolean renderWindow(Stream<O> consumer, List<Object> streamTree) {
            if (WindowAction.class.isAssignableFrom(consumer.getClass())) {
                WindowAction operation = (WindowAction)consumer;
                if (operation.currentWindow() != null) {
                    this.loopSubscriptions(operation.currentWindow(), streamTree);
                }
                return true;
            }
            return false;
        }

        private <O> boolean renderCombine(Stream<O> consumer, List<Object> streamTree) {
            if (CompositeAction.class.isAssignableFrom(consumer.getClass())) {
                CompositeAction operation = (CompositeAction)consumer;
                this.parseComposable(operation.input(), streamTree);
                return true;
            }
            return false;
        }

        private <O> boolean renderDynamicMerge(Stream<O> consumer, List<Object> streamTree) {
            if (DynamicMergeAction.class.isAssignableFrom(consumer.getClass())) {
                DynamicMergeAction operation = (DynamicMergeAction)consumer;
                this.parseComposable(operation.mergedStream(), streamTree);
                return true;
            }
            return false;
        }

        private <O> boolean renderRetryWhen(Stream<O> consumer, List<Object> streamTree) {
            if (RetryWhenAction.class.isAssignableFrom(consumer.getClass())) {
                RetryWhenAction operation = (RetryWhenAction)consumer;
                this.parseComposable(operation.retryStream(), streamTree);
                return true;
            }
            return false;
        }

        private <O> boolean renderGroupBy(Stream<O> consumer, List<Object> streamTree) {
            if (GroupByAction.class.isAssignableFrom(consumer.getClass())) {
                GroupByAction operation = (GroupByAction)consumer;
                for (PushSubscription pushSubscription : operation.groupByMap().values()) {
                    this.loopSubscriptions(pushSubscription, streamTree);
                    if (this.debugVisitor == null) continue;
                    this.debugVisitor.newLine(this.debugVisitor.d, false);
                }
                return true;
            }
            return false;
        }

        private <O> boolean renderMerge(Stream<O> consumer, final List<Object> streamTree) {
            if (FanInAction.class.isAssignableFrom(consumer.getClass())) {
                FanInAction operation = (FanInAction)consumer;
                ((FanInSubscription)operation.getSubscription()).forEach(new Consumer<FanInSubscription.InnerSubscription>(){
                    Subscription delegateSubscription;

                    @Override
                    public void accept(FanInSubscription.InnerSubscription subscription) {
                        this.delegateSubscription = subscription.getDelegate();
                        if (PushSubscription.class.isAssignableFrom(this.delegateSubscription.getClass())) {
                            Stream publisher = ((PushSubscription)this.delegateSubscription).getPublisher();
                            if (publisher == null || StreamVisitor.this.references.contains(publisher)) {
                                return;
                            }
                            if (Action.class.isAssignableFrom(publisher.getClass())) {
                                StreamVisitor.this.parseComposable(((Action)publisher).findOldestUpstream(Stream.class), streamTree);
                            } else if (Stream.class.isAssignableFrom(publisher.getClass())) {
                                StreamVisitor.this.parseComposable(publisher, streamTree);
                            }
                        }
                    }
                });
                return true;
            }
            return false;
        }

        public Map<Object, Object> toMap() {
            return this.streamTree;
        }

        public String toString() {
            return this.debugVisitor.toString();
        }
    }

    static class DebugVisitor
    implements Consumer<Stream<?>> {
        private final StringBuilder appender = new StringBuilder();
        private final List<Throwable> errors = new ArrayList<Throwable>();
        int d = 0;

        DebugVisitor() {
        }

        @Override
        public void accept(Stream<?> composable) {
            this.newLine(this.d);
            this.appender.append(composable.getClass().getSimpleName().isEmpty() ? composable.getClass().getName() + "" + composable : composable.getClass().getSimpleName().replaceAll("Action", "") + "[" + composable + "]");
        }

        public String toString() {
            return this.appender.toString();
        }

        public void newMulticastLine(int d) {
            this.appender.append("\n");
            for (int i = 0; i < d + 1; ++i) {
                this.appender.append("|   ");
            }
        }

        private void newLine(int d) {
            this.newLine(d, true);
        }

        private void newLine(int d, boolean prefix) {
            this.appender.append("\n");
            for (int i = 0; i < d; ++i) {
                this.appender.append("|   ");
            }
            if (prefix) {
                this.appender.append("|____");
            }
        }
    }
}

