/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.action.combination.FanInSubscription;

public final class ConcatAction<O>
extends FanInAction<O, O, O, InnerSubscriber<O>> {
    public ConcatAction(Dispatcher dispatcher, List<? extends Publisher<? extends O>> composables) {
        super(dispatcher, composables);
    }

    @Override
    protected void doNext(O ev) {
        this.broadcastNext(ev);
    }

    protected InnerSubscriber<O> createSubscriber() {
        return new InnerSubscriber(this);
    }

    @Override
    protected FanInSubscription<O, O, O, InnerSubscriber<O>> createFanInSubscription() {
        return new ConcatSubscription(this);
    }

    private final class ConcatSubscription
    extends FanInSubscription<O, O, O, InnerSubscriber<O>> {
        FanInSubscription.InnerSubscription<O, O, InnerSubscriber<O>> current;

        public ConcatSubscription(Subscriber<? super O> subscriber) {
            super(subscriber);
            this.current = null;
        }

        @Override
        int addSubscription(FanInAction.InnerSubscriber s) {
            int newSize = super.addSubscription(s);
            this.current = this.peek();
            return newSize;
        }

        @Override
        protected void parallelRequest(long elements) {
            if (this.current != null) {
                this.current.request(elements);
            } else {
                this.updatePendingRequests(elements);
            }
            if (this.terminated) {
                this.cancel();
            }
        }
    }

    public static final class InnerSubscriber<I>
    extends FanInAction.InnerSubscriber<I, I, I> {
        InnerSubscriber(FanInAction<I, I, I, ? extends FanInAction.InnerSubscriber<I, I, I>> outerAction) {
            super(outerAction);
        }

        public void onSubscribe(Subscription subscription) {
            this.setSubscription(new FanInSubscription.InnerSubscription(subscription, this));
            if (this.outerAction.dynamicMergeAction != null) {
                this.outerAction.dynamicMergeAction.decrementWip();
            }
            if (this.pendingRequests > 0L) {
                this.request(this.pendingRequests);
            }
        }

        public void onNext(I ev) {
            this.outerAction.innerSubscriptions.onNext(ev);
            ++this.emittedSignals;
            if (--this.pendingRequests < 0L) {
                this.pendingRequests = 0L;
            }
        }

        @Override
        public void onComplete() {
            if (TERMINATE_UPDATER.compareAndSet(this, 0, 1)) {
                this.s.cancel();
                this.outerAction.status.set(2);
                long left = FanInSubscription.RUNNING_COMPOSABLE_UPDATER.decrementAndGet(this.outerAction.innerSubscriptions);
                FanInSubscription.InnerSubscription current = this.outerAction.innerSubscriptions.shift(this.sequenceId);
                long request = this.outerAction.innerSubscriptions.pendingRequestSignals();
                if (current != null && request > 0L) {
                    current.request(request);
                }
                if (left == 0L && !this.outerAction.checkDynamicMerge()) {
                    this.outerAction.innerSubscriptions.serialComplete();
                }
            }
        }

        @Override
        public String toString() {
            return "Concat.InnerSubscriber{pending=" + this.pendingRequests + ", emitted=" + this.emittedSignals + "}";
        }
    }
}

