/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.error;

import org.reactivestreams.Publisher;
import reactor.bus.selector.ClassSelector;
import reactor.core.support.Exceptions;
import reactor.fn.BiConsumer;
import reactor.rx.action.error.FallbackAction;

public final class ErrorWithValueAction<T, E extends Throwable>
extends FallbackAction<T> {
    private final BiConsumer<Object, ? super E> consumer;
    private final ClassSelector selector;

    public ErrorWithValueAction(ClassSelector selector, BiConsumer<Object, ? super E> consumer, Publisher<? extends T> fallback) {
        super(fallback);
        this.consumer = consumer;
        this.selector = selector;
    }

    @Override
    protected void doNormalNext(T ev) {
        this.broadcastNext(ev);
    }

    @Override
    protected void doError(Throwable cause) {
        if (this.selector.matches(cause.getClass())) {
            if (this.consumer != null) {
                this.consumer.accept(Exceptions.getFinalValueCause(cause), cause);
            } else if (this.fallback != null) {
                this.doSwitch();
                return;
            }
        }
        super.doError(cause);
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "catch-type=" + this.selector.getObject() + '}';
    }
}

