/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.error;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.rx.action.Action;

public class FallbackAction<T>
extends Action<T, T> {
    protected final Publisher<? extends T> fallback;
    private boolean switched = false;
    private long pendingRequests = 0L;

    public FallbackAction(Publisher<? extends T> fallback) {
        this.fallback = fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doNext(T ev) {
        boolean toSwitch;
        FallbackAction fallbackAction = this;
        synchronized (fallbackAction) {
            if (this.pendingRequests > 0L && this.pendingRequests != Long.MAX_VALUE) {
                --this.pendingRequests;
            }
            toSwitch = this.switched;
        }
        if (toSwitch) {
            this.doFallbackNext(ev);
        } else {
            this.doNormalNext(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void requestUpstream(long capacity, boolean terminated, long elements) {
        FallbackAction fallbackAction = this;
        synchronized (fallbackAction) {
            if ((this.pendingRequests += elements) > 0L) {
                this.pendingRequests = Long.MAX_VALUE;
            }
        }
        super.requestUpstream(capacity, terminated, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSwitch() {
        long pending;
        this.cancel();
        FallbackAction fallbackAction = this;
        synchronized (fallbackAction) {
            this.switched = true;
            pending = this.pendingRequests;
        }
        this.fallback.subscribe((Subscriber)this);
        if (pending > 0L) {
            this.upstreamSubscription.request(pending);
        }
    }

    protected void doNormalNext(T ev) {
        this.broadcastNext(ev);
    }

    protected void doFallbackNext(T ev) {
        this.broadcastNext(ev);
    }
}

