/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.error;

import reactor.fn.Predicate;
import reactor.rx.action.Action;

public final class IgnoreErrorAction<T>
extends Action<T, T> {
    private final Predicate<? super Throwable> ignorePredicate;

    public IgnoreErrorAction(Predicate<? super Throwable> ignorePredicate) {
        this.ignorePredicate = ignorePredicate;
    }

    @Override
    protected void doNext(T ev) {
        this.broadcastNext(ev);
    }

    @Override
    protected void doError(Throwable cause) {
        if (!this.ignorePredicate.test(cause)) {
            super.doError(cause);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "ignorePredicate=" + this.ignorePredicate + '}';
    }
}

