/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import reactor.fn.Predicate;
import reactor.rx.action.Action;

public class SkipAction<T>
extends Action<T, T> {
    private final Predicate<T> startPredicate;
    private final long limit;
    private long counted = 0L;

    public SkipAction(Predicate<T> predicate, long limit) {
        this.startPredicate = predicate;
        this.limit = limit;
    }

    @Override
    protected void doNext(T ev) {
        if (this.counted == -1L || this.counted++ >= this.limit || this.startPredicate != null && !this.startPredicate.test(ev)) {
            this.broadcastNext(ev);
            if (this.counted != 1L) {
                this.counted = -1L;
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "skip=" + this.limit + (this.startPredicate == null ? ", with-start-predicate" : "") + '}';
    }
}

