/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import reactor.fn.Predicate;
import reactor.rx.action.Action;

public class TakeAction<T>
extends Action<T, T> {
    private final Predicate<T> endPredicate;
    private final long limit;
    private long counted = 0L;

    public TakeAction(Predicate<T> predicate, long limit) {
        this.endPredicate = predicate;
        this.limit = limit;
    }

    @Override
    protected void doNext(T ev) {
        this.broadcastNext(ev);
        if (++this.counted >= this.limit || this.endPredicate != null && !this.endPredicate.test(ev)) {
            this.cancel();
            this.broadcastComplete();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "take=" + this.limit + (this.endPredicate == null ? ", with-end-predicate" : "") + '}';
    }
}

