/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.broadcast;

import org.reactivestreams.Subscriber;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.queue.CompletableQueue;
import reactor.core.support.Assert;
import reactor.rx.action.Action;
import reactor.rx.action.Signal;
import reactor.rx.broadcast.Broadcaster;
import reactor.rx.subscription.PushSubscription;
import reactor.rx.subscription.ReactiveSubscription;

public final class BehaviorBroadcaster<O>
extends Broadcaster<O> {
    private final BufferedSignal<O> lastSignal = new BufferedSignal(null);

    public static <T> Broadcaster<T> first(T value) {
        return new BehaviorBroadcaster<T>(null, SynchronousDispatcher.INSTANCE, Long.MAX_VALUE, value);
    }

    public static <T> Broadcaster<T> first(T value, Environment env) {
        return BehaviorBroadcaster.first(value, env, env.getDefaultDispatcher());
    }

    public static <T> Broadcaster<T> first(T value, Dispatcher dispatcher) {
        return BehaviorBroadcaster.first(value, null, dispatcher);
    }

    public static <T> Broadcaster<T> first(T value, Environment env, Dispatcher dispatcher) {
        Assert.state(dispatcher.supportsOrdering(), "Dispatcher provided doesn't support event ordering.  For concurrent consume, refer to Stream#partition/groupBy() method and assign individual single dispatchers");
        return new BehaviorBroadcaster<T>(env, dispatcher, Action.evaluateCapacity(dispatcher.backlogSize()), value);
    }

    public static <T> Broadcaster<T> create(Environment env) {
        return BehaviorBroadcaster.first(null, env);
    }

    public static <T> Broadcaster<T> create(Dispatcher dispatcher) {
        return BehaviorBroadcaster.first(null, dispatcher);
    }

    public static <T> Broadcaster<T> create(Environment env, Dispatcher dispatcher) {
        return BehaviorBroadcaster.first(null, env, dispatcher);
    }

    private BehaviorBroadcaster(Environment environment, Dispatcher dispatcher, long capacity, O defaultVal) {
        super(environment, dispatcher, capacity);
        if (defaultVal != null) {
            this.lastSignal.type = Signal.Type.NEXT;
            this.lastSignal.value = defaultVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doNext(O ev) {
        BehaviorBroadcaster behaviorBroadcaster = this;
        synchronized (behaviorBroadcaster) {
            if (this.lastSignal.type == Signal.Type.COMPLETE || this.lastSignal.type == Signal.Type.ERROR) {
                return;
            }
            this.lastSignal.value = ev;
            this.lastSignal.error = null;
            this.lastSignal.type = Signal.Type.NEXT;
        }
        super.doNext(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComplete() {
        BehaviorBroadcaster behaviorBroadcaster = this;
        synchronized (behaviorBroadcaster) {
            if (this.lastSignal.type == Signal.Type.COMPLETE || this.lastSignal.type == Signal.Type.ERROR) {
                return;
            }
            this.lastSignal.error = null;
            this.lastSignal.type = Signal.Type.COMPLETE;
        }
        super.doComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doError(Throwable ev) {
        BehaviorBroadcaster behaviorBroadcaster = this;
        synchronized (behaviorBroadcaster) {
            if (this.lastSignal.type == Signal.Type.COMPLETE || this.lastSignal.type == Signal.Type.ERROR) {
                return;
            }
            this.lastSignal.value = null;
            this.lastSignal.error = ev;
            this.lastSignal.type = Signal.Type.ERROR;
        }
        super.doError(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PushSubscription<O> createSubscription(Subscriber<? super O> subscriber, CompletableQueue<O> queue) {
        BufferedSignal withDefault;
        BehaviorBroadcaster behaviorBroadcaster = this;
        synchronized (behaviorBroadcaster) {
            if (this.lastSignal.type != null) {
                withDefault = new BufferedSignal(this.lastSignal.type);
                withDefault.error = this.lastSignal.error;
                withDefault.value = this.lastSignal.value;
                withDefault.type = this.lastSignal.type;
            } else {
                withDefault = null;
            }
        }
        if (withDefault != null) {
            if (withDefault.type == Signal.Type.COMPLETE) {
                return new PushSubscription<O>(this, subscriber){

                    @Override
                    public void request(long n) {
                        if (n > 0L && BehaviorBroadcaster.this.capacity == 1L && withDefault.value != null) {
                            BehaviorBroadcaster.this.capacity = 0L;
                            this.subscriber.onNext(withDefault.value);
                        }
                        this.onComplete();
                    }
                };
            }
            if (withDefault.type == Signal.Type.ERROR) {
                return new PushSubscription<O>(this, subscriber){

                    @Override
                    public void request(long n) {
                        this.onError(withDefault.error);
                    }
                };
            }
            if (queue != null) {
                queue.add(withDefault.value);
                return new ReactiveSubscription<O>(this, subscriber, queue){

                    @Override
                    protected void onRequest(long elements) {
                        if (BehaviorBroadcaster.this.upstreamSubscription != null) {
                            super.onRequest(elements);
                            BehaviorBroadcaster.this.requestUpstream(BehaviorBroadcaster.this.capacity, this.buffer.isComplete(), elements);
                        }
                    }
                };
            }
            return new PushSubscription<O>(this, subscriber){
                boolean started;
                {
                    super(publisher, subscriber);
                    this.started = false;
                }

                @Override
                public void request(long n) {
                    if (!this.started && n > 0L) {
                        this.started = true;
                        this.subscriber.onNext(withDefault.value);
                        if (n - 1L > 0L) {
                            super.request(n - 1L);
                        }
                    } else {
                        super.request(n);
                    }
                }

                @Override
                protected void onRequest(long elements) {
                    if (BehaviorBroadcaster.this.upstreamSubscription == null) {
                        this.updatePendingRequests(elements);
                    } else {
                        BehaviorBroadcaster.this.requestUpstream(-1L, this.isComplete(), elements);
                    }
                }
            };
        }
        return super.createSubscription(subscriber, queue);
    }

    private static final class BufferedSignal<O> {
        O value;
        Throwable error;
        Signal.Type type;

        public BufferedSignal(Signal.Type type) {
            this.type = type;
        }
    }
}

