/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.broadcast;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.support.Exceptions;
import reactor.rx.action.support.SerializedSubscriber;
import reactor.rx.broadcast.Broadcaster;

public final class SerializedBroadcaster<O>
extends Broadcaster<O> {
    private final SerializedSubscriber<O> serializer = SerializedSubscriber.create(new Subscriber<O>(){

        public void onSubscribe(Subscription s) {
            SerializedBroadcaster.super.onSubscribe(s);
        }

        public void onNext(O o) {
            SerializedBroadcaster.super.doNext(o);
        }

        public void onError(Throwable t) {
            SerializedBroadcaster.super.doError(t);
        }

        public void onComplete() {
            SerializedBroadcaster.super.doComplete();
        }
    });

    public static <T> Broadcaster<T> create() {
        return new SerializedBroadcaster(null, SynchronousDispatcher.INSTANCE, Long.MAX_VALUE);
    }

    public static <T> Broadcaster<T> create(Environment env) {
        return new SerializedBroadcaster(env, SynchronousDispatcher.INSTANCE, Long.MAX_VALUE);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.serializer.onSubscribe(subscription);
    }

    @Override
    public void onNext(O ev) {
        try {
            this.serializer.onNext(ev);
        }
        catch (Throwable cause) {
            this.doError(Exceptions.addValueAsLastCause(cause, ev));
        }
    }

    @Override
    public void onError(Throwable ev) {
        this.serializer.onError(ev);
    }

    @Override
    public void onComplete() {
        this.serializer.onComplete();
    }

    private SerializedBroadcaster(Environment environment, Dispatcher dispatcher, long capacity) {
        super(environment, dispatcher, capacity);
    }
}

