/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.subscription.ReactiveSubscription;

public final class FutureStream<T>
extends Stream<T> {
    private final Future<? extends T> future;
    private final long time;
    private final TimeUnit unit;

    public FutureStream(Future<? extends T> future) {
        this(future, 0L, null);
    }

    public FutureStream(Future<? extends T> future, long time, TimeUnit unit) {
        this.future = future;
        this.time = time;
        this.unit = unit;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe((Subscription)new ReactiveSubscription<T>(this, subscriber){

            @Override
            public void request(long elements) {
                Action.checkRequest(elements);
                if (this.isComplete()) {
                    return;
                }
                try {
                    Object result = FutureStream.this.unit == null ? FutureStream.this.future.get() : FutureStream.this.future.get(FutureStream.this.time, FutureStream.this.unit);
                    this.subscriber.onNext(result);
                    this.onComplete();
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }
        });
    }
}

