/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import java.util.Iterator;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class IterableStream<T>
extends Stream<T> {
    private final Iterable<? extends T> defaultValues;

    public IterableStream(Iterable<? extends T> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.defaultValues != null) {
            subscriber.onSubscribe((Subscription)new PushSubscription<T>(this, subscriber){
                final Iterator<? extends T> iterator;
                {
                    this.iterator = IterableStream.this.defaultValues.iterator();
                }

                @Override
                public void request(long elements) {
                    for (long i = 0L; i < elements && this.iterator.hasNext(); ++i) {
                        if (this.isComplete()) {
                            return;
                        }
                        this.onNext(this.iterator.next());
                    }
                    if (!this.iterator.hasNext()) {
                        this.onComplete();
                    }
                }
            });
        } else {
            subscriber.onComplete();
        }
    }

    @Override
    public String toString() {
        return "iterable=" + this.defaultValues;
    }
}

