/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class RangeStream
extends Stream<Integer> {
    private final int start;
    private final int end;

    public RangeStream(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public void subscribe(Subscriber<? super Integer> subscriber) {
        if (this.start <= this.end) {
            subscriber.onSubscribe((Subscription)new PushSubscription<Integer>((Stream)this, subscriber){
                int cursor;
                {
                    this.cursor = RangeStream.this.start;
                }

                @Override
                public void request(long elements) {
                    for (long i = 0L; i < elements && this.cursor <= RangeStream.this.end; ++i) {
                        if (this.isComplete()) {
                            return;
                        }
                        this.onNext(this.cursor++);
                    }
                    if (this.cursor > RangeStream.this.end) {
                        this.onComplete();
                    }
                }

                @Override
                public String toString() {
                    return "{cursor=" + this.cursor + "" + (RangeStream.this.end > 0 ? "[" + 100 * (this.cursor - 1) / RangeStream.this.end + "%]" : "") + ", start=" + RangeStream.this.start + ", end=" + RangeStream.this.end + "}";
                }
            });
        } else {
            subscriber.onComplete();
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.start + " to " + this.end + "]";
    }
}

