/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class SingleValueStream<T>
extends Stream<T> {
    public static final SingleValueStream<?> EMPTY = new SingleValueStream<Object>(null);
    private final T value;

    public SingleValueStream(T value) {
        this.value = value;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe((Subscription)new PushSubscription<T>(this, subscriber){
            boolean terminado;
            {
                this.terminado = false;
            }

            @Override
            public void request(long elements) {
                if (this.terminado) {
                    return;
                }
                this.terminado = true;
                if (SingleValueStream.this.value != null) {
                    this.onNext(SingleValueStream.this.value);
                }
                this.onComplete();
            }
        });
    }

    @Override
    public String toString() {
        return "singleValue=" + this.value;
    }
}

