/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class SupplierStream<T>
extends Stream<T> {
    private final Supplier<? extends T> supplier;

    public SupplierStream(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.supplier != null) {
            subscriber.onSubscribe((Subscription)new PushSubscription<T>(this, subscriber){

                @Override
                public void request(long elements) {
                    try {
                        SupplierStream.this.supplyValue(this.subscriber);
                    }
                    catch (Throwable throwable) {
                        this.subscriber.onError(throwable);
                    }
                }
            });
        } else {
            subscriber.onComplete();
        }
    }

    private boolean supplyValue(Subscriber<? super T> subscriber) {
        T supplied = this.supplier.get();
        if (supplied != null) {
            subscriber.onNext(supplied);
            return false;
        }
        subscriber.onComplete();
        return true;
    }
}

