/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import reactor.fn.Consumer;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public class FanOutSubscription<O>
extends PushSubscription<O> {
    private final List<PushSubscription<O>> subscriptions = new ArrayList<PushSubscription<O>>(2);
    private final Queue<PushSubscription<O>> deleteQueue = new LinkedTransferQueue<PushSubscription<O>>();

    public FanOutSubscription(Stream<O> publisher, PushSubscription<O> reactiveSubscriptionA, PushSubscription<O> reactiveSubscriptionB) {
        super(publisher, null);
        this.subscriptions.add(reactiveSubscriptionA);
        this.subscriptions.add(reactiveSubscriptionB);
    }

    @Override
    public void onComplete() {
        this.forEach(new Consumer<PushSubscription<O>>(){

            @Override
            public void accept(PushSubscription<O> subscription) {
                try {
                    subscription.onComplete();
                }
                catch (Throwable throwable) {
                    subscription.onError(throwable);
                }
            }
        });
    }

    @Override
    public void onNext(final O ev) {
        this.forEach(new Consumer<PushSubscription<O>>(){

            @Override
            public void accept(PushSubscription<O> subscription) {
                try {
                    subscription.onNext(ev);
                }
                catch (Throwable throwable) {
                    subscription.onError(throwable);
                }
            }
        });
        this.drainErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainErrors() {
        Queue<PushSubscription<O>> queue = this.deleteQueue;
        synchronized (queue) {
            List<PushSubscription<O>> list = this.subscriptions;
            synchronized (list) {
                PushSubscription<O> deleteSubscription;
                while ((deleteSubscription = this.deleteQueue.poll()) != null) {
                    this.subscriptions.remove(deleteSubscription);
                }
            }
        }
    }

    @Override
    public void cancel() {
        this.forEach(new Consumer<PushSubscription<O>>(){

            @Override
            public void accept(PushSubscription<O> oPushSubscription) {
                oPushSubscription.cancel();
            }
        });
        super.cancel();
    }

    @Override
    public void onError(final Throwable ev) {
        this.forEach(new Consumer<PushSubscription<O>>(){

            @Override
            public void accept(PushSubscription<O> oPushSubscription) {
                oPushSubscription.onError(ev);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        boolean isComplete = false;
        List<PushSubscription<O>> list = this.subscriptions;
        synchronized (list) {
            PushSubscription<O> subscription;
            Iterator<PushSubscription<O>> iterator = this.subscriptions.iterator();
            while (iterator.hasNext() && (isComplete = (subscription = iterator.next()).isComplete())) {
            }
            return isComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<PushSubscription<O>> consumer) {
        List<PushSubscription<O>> list = this.subscriptions;
        synchronized (list) {
            for (PushSubscription<O> subscription : this.subscriptions) {
                if (subscription == null) continue;
                consumer.accept(subscription);
            }
        }
    }

    public List<PushSubscription<O>> getSubscriptions() {
        return Collections.unmodifiableList(this.subscriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<PushSubscription<O>> list = this.subscriptions;
        synchronized (list) {
            return this.subscriptions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(PushSubscription<O> subscription) {
        Queue<PushSubscription<O>> queue = this.deleteQueue;
        synchronized (queue) {
            return this.deleteQueue.add(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(PushSubscription<O> subscription) {
        List<PushSubscription<O>> list = this.subscriptions;
        synchronized (list) {
            return this.subscriptions.add(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(PushSubscription<O> subscription) {
        List<PushSubscription<O>> list = this.subscriptions;
        synchronized (list) {
            return this.subscriptions.contains(subscription);
        }
    }
}

