/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.alloc.factory;

import java.lang.reflect.Constructor;
import reactor.fn.Supplier;

public class NoArgConstructorFactory<T>
implements Supplier<T> {
    private final Class<T> type;
    private final Constructor<T> ctor;

    public NoArgConstructorFactory(Class<T> type) {
        this.type = type;
        try {
            this.ctor = type.getConstructor(new Class[0]);
            this.ctor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public T get() {
        try {
            return this.ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

