/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.InsufficientCapacityException;
import reactor.core.dispatch.SingleThreadDispatcher;
import reactor.core.dispatch.wait.WaitingMood;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.fn.Consumer;
import reactor.jarjar.com.lmax.disruptor.BlockingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.EventFactory;
import reactor.jarjar.com.lmax.disruptor.EventHandler;
import reactor.jarjar.com.lmax.disruptor.ExceptionHandler;
import reactor.jarjar.com.lmax.disruptor.RingBuffer;
import reactor.jarjar.com.lmax.disruptor.TimeoutException;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.dsl.Disruptor;
import reactor.jarjar.com.lmax.disruptor.dsl.ProducerType;

public final class RingBufferDispatcher
extends SingleThreadDispatcher
implements WaitingMood {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executor;
    private final Disruptor<RingBufferTask> disruptor;
    private final RingBuffer<RingBufferTask> ringBuffer;
    private final WaitingMood waitingMood;

    public RingBufferDispatcher(String name) {
        this(name, 1024);
    }

    public RingBufferDispatcher(String name, int bufferSize) {
        this(name, bufferSize, null);
    }

    public RingBufferDispatcher(String name, int bufferSize, Consumer<Throwable> uncaughtExceptionHandler) {
        this(name, bufferSize, uncaughtExceptionHandler, ProducerType.MULTI, new BlockingWaitStrategy());
    }

    public RingBufferDispatcher(String name, int bufferSize, final Consumer<Throwable> uncaughtExceptionHandler, ProducerType producerType, WaitStrategy waitStrategy) {
        super(bufferSize);
        this.waitingMood = WaitingMood.class.isAssignableFrom(waitStrategy.getClass()) ? (WaitingMood)((Object)waitStrategy) : null;
        this.executor = Executors.newSingleThreadExecutor(new NamedDaemonThreadFactory(name, this.getContext()));
        this.disruptor = new Disruptor<RingBufferTask>(new EventFactory<RingBufferTask>(){

            @Override
            public RingBufferTask newInstance() {
                return new RingBufferTask();
            }
        }, bufferSize, this.executor, producerType, waitStrategy);
        this.disruptor.handleExceptionsWith(new ExceptionHandler(){

            public void handleEventException(Throwable ex, long sequence, Object event) {
                this.handleOnStartException(ex);
            }

            @Override
            public void handleOnStartException(Throwable ex) {
                if (null != uncaughtExceptionHandler) {
                    uncaughtExceptionHandler.accept(ex);
                } else {
                    RingBufferDispatcher.this.log.error(ex.getMessage(), ex);
                }
            }

            @Override
            public void handleOnShutdownException(Throwable ex) {
                this.handleOnStartException(ex);
            }
        });
        this.disruptor.handleEventsWith(new EventHandler<RingBufferTask>(){

            @Override
            public void onEvent(RingBufferTask task, long sequence, boolean endOfBatch) throws Exception {
                task.run();
            }
        });
        this.ringBuffer = this.disruptor.start();
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        if (!this.alive()) {
            return false;
        }
        super.shutdown();
        long start = System.nanoTime();
        long timeoutNano = timeUnit.toNanos(timeout);
        try {
            this.disruptor.shutdown(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            return false;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                RingBufferDispatcher.this.executor.shutdown();
                latch.countDown();
            }
        });
        try {
            while (!latch.await(1L, TimeUnit.MILLISECONDS)) {
                long now = System.nanoTime();
                if ((timeoutNano -= now - (start = now)) <= 0L) {
                    return false;
                }
                this.disruptor.shutdown(timeoutNano, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            return false;
        }
        try {
            this.executor.awaitTermination(timeoutNano -= System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        this.disruptor.shutdown();
        super.shutdown();
    }

    @Override
    public void forceShutdown() {
        this.executor.shutdownNow();
        this.disruptor.halt();
        super.forceShutdown();
    }

    @Override
    public long remainingSlots() {
        return this.ringBuffer.remainingCapacity();
    }

    @Override
    public void nervous() {
        if (this.waitingMood != null) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    RingBufferDispatcher.this.waitingMood.nervous();
                }
            });
        }
    }

    @Override
    public void calm() {
        if (this.waitingMood != null) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    RingBufferDispatcher.this.waitingMood.calm();
                }
            });
        }
    }

    @Override
    protected AbstractLifecycleDispatcher.Task tryAllocateTask() throws InsufficientCapacityException {
        try {
            long seqId = this.ringBuffer.tryNext();
            return this.ringBuffer.get(seqId).setSequenceId(seqId);
        }
        catch (reactor.jarjar.com.lmax.disruptor.InsufficientCapacityException e) {
            throw InsufficientCapacityException.INSTANCE;
        }
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateTask() {
        long seqId = this.ringBuffer.next();
        return this.ringBuffer.get(seqId).setSequenceId(seqId);
    }

    @Override
    protected void execute(AbstractLifecycleDispatcher.Task task) {
        this.ringBuffer.publish(((RingBufferTask)task).getSequenceId());
    }

    private class RingBufferTask
    extends SingleThreadDispatcher.SingleThreadTask {
        private long sequenceId;

        private RingBufferTask() {
        }

        public long getSequenceId() {
            return this.sequenceId;
        }

        public RingBufferTask setSequenceId(long sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }
    }
}

