/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.processor.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.reactivestreams.Subscriber;
import reactor.core.processor.MutableSignal;
import reactor.core.support.Exceptions;
import reactor.jarjar.com.lmax.disruptor.AlertException;
import reactor.jarjar.com.lmax.disruptor.RingBuffer;
import reactor.jarjar.com.lmax.disruptor.Sequence;
import reactor.jarjar.com.lmax.disruptor.SequenceBarrier;
import reactor.jarjar.com.lmax.disruptor.TimeoutException;

public final class RingBufferSubscriberUtils {
    private RingBufferSubscriberUtils() {
    }

    public static <E> void onNext(E value, RingBuffer<MutableSignal<E>> ringBuffer) {
        if (value == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        long seqId = ringBuffer.next();
        MutableSignal<E> signal = ringBuffer.get(seqId);
        signal.type = MutableSignal.Type.NEXT;
        signal.value = value;
        ringBuffer.publish(seqId);
    }

    public static <E> void onError(Throwable error, RingBuffer<MutableSignal<E>> ringBuffer) {
        if (error == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        long seqId = ringBuffer.next();
        MutableSignal<E> signal = ringBuffer.get(seqId);
        signal.type = MutableSignal.Type.ERROR;
        signal.value = null;
        signal.error = error;
        ringBuffer.publish(seqId);
    }

    public static <E> void onComplete(RingBuffer<MutableSignal<E>> ringBuffer) {
        long seqId = ringBuffer.next();
        MutableSignal<E> signal = ringBuffer.get(seqId);
        signal.type = MutableSignal.Type.COMPLETE;
        signal.value = null;
        signal.error = null;
        ringBuffer.publish(seqId);
    }

    public static <E> void route(MutableSignal<E> task, Subscriber<? super E> subscriber) {
        if (task.type == MutableSignal.Type.NEXT && null != task.value) {
            subscriber.onNext(task.value);
        } else if (task.type == MutableSignal.Type.COMPLETE) {
            subscriber.onComplete();
        } else if (task.type == MutableSignal.Type.ERROR) {
            subscriber.onError(task.error);
        }
    }

    public static <E> void routeOnce(MutableSignal<E> task, Subscriber<? super E> subscriber) {
        Object value = task.value;
        task.value = null;
        try {
            if (task.type == MutableSignal.Type.NEXT && null != value) {
                subscriber.onNext(value);
            } else if (task.type == MutableSignal.Type.COMPLETE) {
                subscriber.onComplete();
            } else if (task.type == MutableSignal.Type.ERROR) {
                subscriber.onError(task.error);
            }
        }
        catch (Throwable t) {
            task.value = value;
            throw t;
        }
    }

    public static <T> boolean waitRequestOrTerminalEvent(Sequence pendingRequest, RingBuffer<MutableSignal<T>> ringBuffer, SequenceBarrier barrier, Subscriber<? super T> subscriber, AtomicBoolean isRunning) {
        long waitedSequence = ringBuffer.getCursor() + 1L;
        try {
            MutableSignal<T> event = null;
            while (pendingRequest.get() < 0L) {
                if (event == null) {
                    barrier.waitFor(waitedSequence);
                    event = ringBuffer.get(waitedSequence);
                    if (event.type == MutableSignal.Type.COMPLETE) {
                        try {
                            subscriber.onComplete();
                            return false;
                        }
                        catch (Throwable t) {
                            Exceptions.throwIfFatal(t);
                            subscriber.onError(t);
                            return false;
                        }
                    }
                    if (event.type == MutableSignal.Type.ERROR) {
                        subscriber.onError(event.error);
                        return false;
                    }
                } else {
                    barrier.checkAlert();
                }
                LockSupport.parkNanos(1L);
            }
        }
        catch (TimeoutException event) {
        }
        catch (AlertException ae) {
            if (!isRunning.get()) {
                return false;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return true;
    }
}

