/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.FluxOnAssembly;

final class ConnectableFluxOnAssembly<T>
extends ConnectableFlux<T>
implements Fuseable,
AssemblyOp {
    final ConnectableFlux<T> source;
    final String stacktrace;

    public ConnectableFluxOnAssembly(ConnectableFlux<T> source, boolean trace) {
        this.source = source;
        this.stacktrace = trace ? FluxOnAssembly.takeStacktrace(source) : null;
    }

    public void subscribe(Subscriber<? super T> s) {
        FluxOnAssembly.subscribe(s, this.source, this.stacktrace, this);
    }

    @Override
    public void connect(Consumer<? super Cancellation> cancelSupport) {
        this.source.connect(cancelSupport);
    }

    @Override
    public Object upstream() {
        return this.source;
    }
}

