/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;

final class FluxDematerialize<T>
extends FluxSource<Signal<T>, T> {
    public FluxDematerialize(Publisher<Signal<T>> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        this.source.subscribe(new DematerializeSubscriber<T>(subscriber));
    }

    static final class DematerializeSubscriber<T>
    extends AbstractQueue<T>
    implements Subscriber<Signal<T>>,
    Subscription,
    BooleanSupplier {
        final Subscriber<? super T> actual;
        Subscription s;
        T value;
        boolean done;
        long produced;
        volatile long requested;
        static final AtomicLongFieldUpdater<DematerializeSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(DematerializeSubscriber.class, "requested");
        volatile boolean cancelled;
        Throwable error;

        public DematerializeSubscriber(Subscriber<? super T> subscriber) {
            this.actual = subscriber;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(1L);
            }
        }

        public void onNext(Signal<T> t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (t.isOnComplete()) {
                this.s.cancel();
                this.onComplete();
            } else if (t.isOnError()) {
                this.s.cancel();
                this.onError(t.getThrowable());
            } else if (t.isOnNext()) {
                T v = this.value;
                this.value = t.get();
                if (v != null) {
                    ++this.produced;
                    this.actual.onNext(v);
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.error = t;
            long p = this.produced;
            if (p != 0L) {
                REQUESTED.addAndGet(this, -p);
            }
            DrainUtils.postCompleteDelayError(this.actual, this, REQUESTED, this, this, this.error);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            long p = this.produced;
            if (p != 0L) {
                REQUESTED.addAndGet(this, -p);
            }
            DrainUtils.postCompleteDelayError(this.actual, this, REQUESTED, this, this, this.error);
        }

        public void request(long n) {
            if (Operators.validate(n) && !DrainUtils.postCompleteRequestDelayError(n, this.actual, this, REQUESTED, this, this, this.error)) {
                this.s.request(n);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public int size() {
            return this.value == null ? 0 : 1;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null;
        }

        @Override
        public boolean offer(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T peek() {
            return this.value;
        }

        @Override
        public T poll() {
            T v = this.value;
            if (v != null) {
                this.value = null;
                return v;
            }
            return null;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

