/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxHandleFuseable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SynchronousSink;

final class FluxHandle<T, R>
extends FluxSource<T, R> {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    public FluxHandle(Publisher<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (this.source instanceof Fuseable) {
            this.source.subscribe(new FluxHandleFuseable.HandleFuseableSubscriber<T, R>(s, this.handler));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new HandleConditionalSubscriber<T, R>(cs, this.handler));
            return;
        }
        this.source.subscribe(new HandleSubscriber<T, R>(s, this.handler));
    }

    static final class HandleConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Trackable,
    SynchronousSink<R> {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Subscription s;

        public HandleConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(this.error);
                    return;
                }
                this.actual.onComplete();
            } else if (v == null) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return false;
            }
            R v = this.data;
            boolean emit = false;
            this.data = null;
            if (v != null) {
                emit = this.actual.tryOnNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(this.error);
                } else {
                    this.actual.onComplete();
                }
            }
            return emit;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.handler;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Operators.onOperatorError(Objects.requireNonNull(e, "error"));
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }

    static final class HandleSubscriber<T, R>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Fuseable.ConditionalSubscriber<T>,
    Trackable,
    SynchronousSink<R> {
        final Subscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Subscription s;

        public HandleSubscriber(Subscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(this.error);
                    return;
                }
                this.actual.onComplete();
            } else if (v == null) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return false;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(this.error);
                    return false;
                }
                this.actual.onComplete();
            }
            return v != null;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Operators.onOperatorError(Objects.requireNonNull(e, "error"));
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.handler;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

