/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxJust<T>
extends Flux<T>
implements Fuseable.ScalarCallable<T>,
Fuseable,
Receiver {
    final T value;

    public FluxJust(T value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public T call() {
        return this.value;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(new WeakScalarSubscription<T>(this.value, subscriber));
        }
        catch (Throwable throwable) {
            subscriber.onError(Operators.onOperatorError(throwable));
        }
    }

    @Override
    public Object upstream() {
        return this.value;
    }

    static final class WeakScalarSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    Receiver,
    Trackable {
        boolean terminado;
        final T value;
        final Subscriber<? super T> subscriber;

        public WeakScalarSubscription(T value, Subscriber<? super T> subscriber) {
            this.value = value;
            this.subscriber = subscriber;
        }

        public void request(long elements) {
            if (this.terminado) {
                return;
            }
            this.terminado = true;
            if (this.value != null) {
                this.subscriber.onNext(this.value);
            }
            this.subscriber.onComplete();
        }

        public void cancel() {
            this.terminado = true;
        }

        @Override
        public boolean isStarted() {
            return !this.terminado;
        }

        @Override
        public boolean isTerminated() {
            return this.terminado;
        }

        @Override
        public Object upstream() {
            return this.value;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public T poll() {
            if (!this.terminado) {
                this.terminado = true;
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.terminado;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            this.terminado = true;
        }
    }
}

