/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxMapSignal<T, R>
extends FluxSource<T, R> {
    final Function<? super T, ? extends R> mapperNext;
    final Function<Throwable, ? extends R> mapperError;
    final Supplier<? extends R> mapperComplete;

    public FluxMapSignal(Publisher<? extends T> source, Function<? super T, ? extends R> mapperNext, Function<Throwable, ? extends R> mapperError, Supplier<? extends R> mapperComplete) {
        super(source);
        if (mapperNext == null && mapperError == null && mapperComplete == null) {
            throw new NullPointerException("Map Signal needs at least one valid mapper");
        }
        this.mapperNext = mapperNext;
        this.mapperError = mapperError;
        this.mapperComplete = mapperComplete;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        this.source.subscribe(new FluxMapSignalSubscriber(s, this));
    }

    static final class FluxMapSignalSubscriber<T, R>
    extends AbstractQueue<R>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Trackable,
    Subscription,
    BooleanSupplier {
        final Subscriber<? super R> actual;
        final FluxMapSignal<T, R> parent;
        boolean done;
        Subscription s;
        R value;
        volatile long requested;
        static final AtomicLongFieldUpdater<FluxMapSignalSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(FluxMapSignalSubscriber.class, "requested");
        volatile boolean cancelled;
        long produced;

        public FluxMapSignalSubscriber(Subscriber<? super R> actual, FluxMapSignal<T, R> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            Object v;
            if (this.done || this.parent.mapperNext == null) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                v = this.parent.mapperNext.apply(t);
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (v == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                return;
            }
            ++this.produced;
            this.actual.onNext(v);
        }

        public void onError(Throwable t) {
            Object v;
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            if (this.parent.mapperError == null) {
                this.actual.onError(t);
                return;
            }
            try {
                v = this.parent.mapperError.apply(t);
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (v == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                return;
            }
            this.value = v;
            long p = this.produced;
            if (p != 0L) {
                REQUESTED.addAndGet(this, -p);
            }
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        public void onComplete() {
            Object v;
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.parent.mapperComplete == null) {
                this.actual.onComplete();
                return;
            }
            try {
                v = this.parent.mapperComplete.get();
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e));
                return;
            }
            if (v == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value.")));
                return;
            }
            this.value = v;
            long p = this.produced;
            if (p != 0L) {
                REQUESTED.addAndGet(this, -p);
            }
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            if (Operators.validate(n) && !DrainUtils.postCompleteRequest(n, this.actual, this, REQUESTED, this, this)) {
                this.s.request(n);
            }
        }

        @Override
        public boolean offer(R e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public R poll() {
            R v = this.value;
            if (v != null) {
                this.value = null;
                return v;
            }
            return null;
        }

        @Override
        public R peek() {
            return this.value;
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        @Override
        public Iterator<R> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.value == null ? 0 : 1;
        }
    }
}

