/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalPeek;

final class FluxPeek<T>
extends FluxSource<T, T>
implements SignalPeek<T> {
    final Consumer<? super Subscription> onSubscribeCall;
    final Consumer<? super T> onNextCall;
    final Consumer<? super Throwable> onErrorCall;
    final Runnable onCompleteCall;
    final Runnable onAfterTerminateCall;
    final LongConsumer onRequestCall;
    final Runnable onCancelCall;

    public FluxPeek(Publisher<? extends T> source, Consumer<? super Subscription> onSubscribeCall, Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall, LongConsumer onRequestCall, Runnable onCancelCall) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.source instanceof Fuseable) {
            this.source.subscribe(new FluxPeekFuseable.PeekFuseableSubscriber<T>(s, this));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber s2 = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new FluxPeekFuseable.PeekConditionalSubscriber(s2, this));
            return;
        }
        this.source.subscribe(new PeekSubscriber<T>(s, this));
    }

    @Override
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    public Consumer<? super T> onNextCall() {
        return this.onNextCall;
    }

    @Override
    public Consumer<? super Throwable> onErrorCall() {
        return this.onErrorCall;
    }

    @Override
    public Runnable onCompleteCall() {
        return this.onCompleteCall;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        return this.onAfterTerminateCall;
    }

    @Override
    public LongConsumer onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    public Runnable onCancelCall() {
        return this.onCancelCall;
    }

    static final class PeekSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Receiver,
    Producer {
        final Subscriber<? super T> actual;
        final SignalPeek<T> parent;
        Subscription s;
        boolean done;

        public PeekSubscriber(Subscriber<? super T> actual, SignalPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (this.parent.onRequestCall() != null) {
                try {
                    this.parent.onRequestCall().accept(n);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.request(n);
        }

        public void cancel() {
            if (this.parent.onCancelCall() != null) {
                try {
                    this.parent.onCancelCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (this.parent.onSubscribeCall() != null) {
                try {
                    this.parent.onSubscribeCall().accept(s);
                }
                catch (Throwable e) {
                    Operators.error(this.actual, Operators.onOperatorError(s, e));
                    return;
                }
            }
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            block8: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (this.parent.onErrorCall() != null) {
                    this.parent.onErrorCall().accept(t);
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (this.parent.onErrorCall() != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block8;
                    throw use;
                }
            }
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(null, e, t);
                    e.addSuppressed(t);
                    if (this.parent.onErrorCall() != null) {
                        this.parent.onErrorCall().accept(_e);
                    }
                    Operators.onErrorDropped(_e);
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.parent.onCompleteCall() != null) {
                try {
                    this.parent.onCompleteCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(e));
                    return;
                }
            }
            this.actual.onComplete();
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e);
                    if (this.parent.onErrorCall() != null) {
                        this.parent.onErrorCall().accept(_e);
                    }
                    Operators.onErrorDropped(_e);
                }
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

