/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxResume<T>
extends FluxSource<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;

    public FluxResume(Publisher<? extends T> source, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
        super(source);
        this.nextFactory = Objects.requireNonNull(nextFactory, "nextFactory");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new ResumeSubscriber<T>(s, this.nextFactory));
    }

    static final class ResumeSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T>
    implements Loopback {
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;
        boolean second;

        public ResumeSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
            super(actual);
            this.nextFactory = nextFactory;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (!this.second) {
                this.subscriber.onSubscribe((Subscription)this);
            }
            this.set(s);
        }

        public void onNext(T t) {
            this.subscriber.onNext(t);
            if (!this.second) {
                this.producedOne();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.second) {
                Publisher<? extends T> p;
                this.second = true;
                try {
                    p = this.nextFactory.apply(t);
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e);
                    if (t != _e) {
                        _e.addSuppressed(t);
                    }
                    this.subscriber.onError(_e);
                    return;
                }
                if (p == null) {
                    NullPointerException t2 = new NullPointerException("The nextFactory returned a null Publisher");
                    t2.addSuppressed(t);
                    this.subscriber.onError((Throwable)t2);
                } else {
                    p.subscribe((Subscriber)this);
                }
            } else {
                this.subscriber.onError(t);
            }
        }

        @Override
        public Object connectedInput() {
            return this.nextFactory;
        }
    }
}

