/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxRetry<T>
extends FluxSource<T, T> {
    final long times;

    public FluxRetry(Publisher<? extends T> source, long times) {
        super(source);
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required");
        }
        this.times = times;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        RetrySubscriber<T> parent = new RetrySubscriber<T>(this.source, s, this.times);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }

    static final class RetrySubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T> source;
        long remaining;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetrySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetrySubscriber.class, "wip");
        long produced;

        public RetrySubscriber(Publisher<? extends T> source, Subscriber<? super T> actual, long remaining) {
            super(actual);
            this.source = source;
            this.remaining = remaining;
        }

        public void onNext(T t) {
            ++this.produced;
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                if (r == 0L) {
                    this.subscriber.onError(t);
                    return;
                }
                this.remaining = r - 1L;
            }
            this.resubscribe();
        }

        void resubscribe() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    this.source.subscribe((Subscriber)this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

