/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxScan<T>
extends FluxSource<T, T> {
    final BiFunction<T, ? super T, T> accumulator;

    public FluxScan(Publisher<? extends T> source, BiFunction<T, ? super T, T> accumulator) {
        super(source);
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new AccumulateSubscriber<T>(s, this.accumulator));
    }

    static final class AccumulateSubscriber<T>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Trackable {
        final Subscriber<? super T> actual;
        final BiFunction<T, ? super T, T> accumulator;
        Subscription s;
        T value;
        boolean done;

        public AccumulateSubscriber(Subscriber<? super T> actual, BiFunction<T, ? super T, T> accumulator) {
            this.actual = actual;
            this.accumulator = accumulator;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            T v = this.value;
            if (v != null) {
                try {
                    t = this.accumulator.apply(v, t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (t == null) {
                    this.s.cancel();
                    this.onError(new NullPointerException("The accumulator returned a null value"));
                    return;
                }
            }
            this.value = t;
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.accumulator;
        }

        @Override
        public Object connectedOutput() {
            return this.value;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

