/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.Flux;

public class FluxSource<I, O>
extends Flux<O>
implements Receiver {
    protected final Publisher<? extends I> source;

    public static <I> Flux<I> wrap(Publisher<? extends I> source) {
        if (source instanceof Fuseable) {
            return FluxSource.onAssembly(new FuseableFluxSource<I>(source));
        }
        return FluxSource.onAssembly(new FluxSource(source));
    }

    protected FluxSource(Publisher<? extends I> source) {
        this.source = Objects.requireNonNull(source);
    }

    public void subscribe(Subscriber<? super O> s) {
        this.source.subscribe(s);
    }

    @Override
    public String toString() {
        return "{ operator : \"" + this.getClass().getSimpleName().replaceAll("Flux", "") + "\" " + '}';
    }

    public final Publisher<? extends I> upstream() {
        return this.source;
    }

    static final class FuseableFluxSource<I>
    extends FluxSource<I, I>
    implements Fuseable {
        public FuseableFluxSource(Publisher<? extends I> source) {
            super(source);
        }
    }
}

