/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxIterable;
import reactor.core.publisher.Operators;

final class FluxStream<T>
extends Flux<T>
implements Receiver,
Fuseable {
    final Stream<? extends T> stream;

    public FluxStream(Stream<? extends T> iterable) {
        this.stream = Objects.requireNonNull(iterable, "stream");
    }

    @Override
    public Object upstream() {
        return this.stream;
    }

    public void subscribe(Subscriber<? super T> s) {
        Iterator it;
        try {
            it = this.stream.iterator();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        FluxIterable.subscribe(s, it);
    }
}

