/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;

final class LambdaSubscriber<T>
implements Subscriber<T>,
Receiver,
Cancellation,
Trackable {
    final Consumer<? super T> consumer;
    final Consumer<? super Throwable> errorConsumer;
    final Runnable completeConsumer;
    final Consumer<? super Subscription> subscriptionConsumer;
    volatile Subscription subscription;
    static final AtomicReferenceFieldUpdater<LambdaSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(LambdaSubscriber.class, Subscription.class, "subscription");

    public LambdaSubscriber(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Subscription> subscriptionConsumer) {
        this.consumer = consumer;
        this.errorConsumer = errorConsumer;
        this.completeConsumer = completeConsumer;
        this.subscriptionConsumer = subscriptionConsumer;
    }

    public final void onSubscribe(Subscription s) {
        if (Operators.validate(this.subscription, s)) {
            this.subscription = s;
            try {
                if (this.subscriptionConsumer != null) {
                    this.subscriptionConsumer.accept((Subscription)s);
                } else {
                    s.request(Long.MAX_VALUE);
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                s.cancel();
                this.onError(t);
            }
        }
    }

    @Override
    public Object upstream() {
        return this.subscription;
    }

    public final void onComplete() {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.run();
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                this.onError(t);
            }
        }
    }

    public final void onError(Throwable t) {
        if (t == null) {
            throw Exceptions.argumentIsNullException();
        }
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            Operators.onErrorDropped(t);
            return;
        }
        if (this.errorConsumer == null) {
            throw Exceptions.errorCallbackNotImplemented(t);
        }
        this.errorConsumer.accept(t);
    }

    public final void onNext(T x) {
        if (x == null) {
            throw Exceptions.argumentIsNullException();
        }
        try {
            if (this.consumer != null) {
                this.consumer.accept(x);
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            this.subscription.cancel();
            this.onError(t);
        }
    }

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isStarted() {
        return this.subscription != null;
    }

    @Override
    public boolean isTerminated() {
        return this.subscription == Operators.cancelledSubscription();
    }

    @Override
    public void dispose() {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s != null && s != Operators.cancelledSubscription()) {
            s.cancel();
        }
    }
}

