/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoCallable<T>
extends Mono<T>
implements Receiver,
Callable<T>,
Fuseable {
    final Callable<? extends T> callable;

    public MonoCallable(Callable<? extends T> callable) {
        this.callable = Objects.requireNonNull(callable, "callable");
    }

    @Override
    public Object upstream() {
        return this.callable;
    }

    public void subscribe(Subscriber<? super T> s) {
        T t;
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(s);
        s.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            t = this.callable.call();
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e));
            return;
        }
        if (t == null) {
            s.onError(Operators.onOperatorError(new NullPointerException("The callable returned null")));
            return;
        }
        sds.complete(t);
    }

    @Override
    public T block() {
        return this.blockMillis(-1L);
    }

    @Override
    public T blockMillis(long m) {
        try {
            return this.callable.call();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public T call() throws Exception {
        return this.callable.call();
    }
}

